/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.common.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.model.massupdate.MassUpdateUnitRuleRequest;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnit;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public final class RulesUpdateCommonService {
    private RulesUpdateCommonService() {
    }

    public static void deleteAttributesFromObjectNode(ObjectNode dslRequest, String ... attributes) {
        if (dslRequest != null && attributes.length > 0) {
            Arrays.stream(attributes).forEach(arg_0 -> ((ObjectNode)dslRequest).remove(arg_0));
        }
    }

    public static void setMassUpdateUnitRuleRequest(MassUpdateUnitRuleRequest massUpdateUnitRuleRequest, RuleActions ruleActions, ObjectNode dslRequest) {
        massUpdateUnitRuleRequest.setRuleActions(ruleActions);
        massUpdateUnitRuleRequest.setDslRequest((JsonNode)dslRequest);
    }

    public static ArchiveUnit fillOriginatingAgencyName(ResultsDto originResponse, Map<String, AgencyModelDto> actualAgenciesMapById) {
        AgencyModelDto agencyModel;
        ArchiveUnit archiveUnit = new ArchiveUnit();
        BeanUtils.copyProperties((Object)originResponse, (Object)((Object)archiveUnit));
        if (actualAgenciesMapById != null && !actualAgenciesMapById.isEmpty() && (agencyModel = actualAgenciesMapById.get(originResponse.getOriginatingAgency())) != null) {
            archiveUnit.setOriginatingAgencyName(agencyModel.getName());
        }
        return archiveUnit;
    }
}

