/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractService;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dto.AccessContractVitamDto;
import org.springframework.beans.factory.annotation.Autowired;

public class VitamUIAccessContractService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessContractService.class);
    private final AdminExternalClient adminExternalClient;

    @Autowired
    public VitamUIAccessContractService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public RequestResponse<AccessContractVitamDto> patchAccessContract(VitamContext vitamContext, String id, JsonNode jsonNode) throws InvalidParseOperationException, AccessExternalClientException {
        LOGGER.debug("patch: {}, {}", (Object)id, (Object)jsonNode);
        LOGGER.debug("Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.updateAccessContract(vitamContext, id, jsonNode);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }
}

