/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.appserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientNotFoundException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalNotFoundException;
import fr.gouv.vitam.common.CharsetUtils;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.external.client.DefaultClient;
import fr.gouv.vitam.common.external.client.IngestCollection;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.VitamConstants;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.export.dip.DipRequest;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.AsyncInputStreamHelper;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.server.application.resources.BasicVitamStatusServiceImpl;
import fr.gouv.vitam.common.server.application.resources.VitamStatusService;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.xsrf.filter.XSRFFilter;
import fr.gouv.vitam.common.xsrf.filter.XSRFHelper;
import fr.gouv.vitam.ihmdemo.appserver.LoginModel;
import fr.gouv.vitam.ihmdemo.appserver.WebApplicationConfig;
import fr.gouv.vitam.ihmdemo.common.api.IhmWebAppHeader;
import fr.gouv.vitam.ihmdemo.common.pagination.OffsetBasedPagination;
import fr.gouv.vitam.ihmdemo.common.pagination.PaginationHelper;
import fr.gouv.vitam.ihmdemo.common.utils.PermissionReader;
import fr.gouv.vitam.ihmdemo.core.DslQueryHelper;
import fr.gouv.vitam.ihmdemo.core.JsonTransformer;
import fr.gouv.vitam.ihmdemo.core.UserInterfaceTransactionManager;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

@Path(value="/v1/api")
@ApplicationPath(value="webresources")
public class WebApplicationResource
extends ApplicationStatusResource {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String ATTACHMENT_FILENAME_ERROR_REPORT_JSON = "attachment; filename=rapport.json";
    public static final String X_SIZE_TOTAL = "X-Size-Total";
    public static final String X_CHUNK_OFFSET = "X-Chunk-Offset";
    private static final String CSV = ".csv";
    private static final String JSON = ".json";
    private static final String JSONL = ".jsonl";
    private static final String DISTRIBUTION = "distribution";
    private static final String BATCH_REPORT = "batchreport";
    private static final String AGENCIES = "agencies";
    private static final String RULES = "rules";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WebApplicationResource.class);
    private static final String CODE_VITAM = "code_vitam";
    private static final String BAD_REQUEST_EXCEPTION_MSG = "Bad request Exception";
    private static final String ACCESS_CLIENT_NOT_FOUND_EXCEPTION_MSG = "Access client unavailable";
    private static final String ACCESS_SERVER_EXCEPTION_MSG = "Access Server exception";
    private static final String INTERNAL_SERVER_ERROR_MSG = "INTERNAL SERVER ERROR";
    private static final String SEARCH_CRITERIA_MANDATORY_MSG = "Search criteria payload is mandatory";
    private static final String UPDATE_RULES_KEY = "UpdatedRules";
    private static final String FIELD_ID_KEY = "fieldId";
    private static final String NEW_FIELD_VALUE_KEY = "newFieldValue";
    private static final String BLANK_OPERATION_ID = "Operation identifier should be filled";
    private static final String LOGBOOK_CLIENT_NOT_FOUND_EXCEPTION_MSG = "Logbook Client NOT FOUND Exception";
    private static final ConcurrentMap<String, List<Object>> uploadRequestsStatus = new ConcurrentHashMap<String, List<Object>>();
    private static final int GUID_INDEX = 0;
    private Map<String, AtomicLong> uploadMap = new HashMap<String, AtomicLong>();
    private ExecutorService threadPoolExecutor = Executors.newCachedThreadPool((ThreadFactory)VitamThreadFactory.getInstance());
    private final UserInterfaceTransactionManager userInterfaceTransactionManager;
    private final DslQueryHelper dslQueryHelper;
    private final PaginationHelper paginationHelper;
    private final IngestExternalClientFactory ingestExternalClientFactory;
    private final AdminExternalClientFactory adminExternalClientFactory;
    private final Set<String> permissions;
    private final List<String> secureMode;
    private final List<MediaType> allowedToVisualizeMediaTypes;

    public WebApplicationResource(Set<String> permissions, WebApplicationConfig webApplicationConfig) {
        super((VitamStatusService)new BasicVitamStatusServiceImpl());
        this.permissions = permissions;
        this.ingestExternalClientFactory = IngestExternalClientFactory.getInstance();
        this.adminExternalClientFactory = AdminExternalClientFactory.getInstance();
        this.userInterfaceTransactionManager = UserInterfaceTransactionManager.getInstance();
        this.secureMode = webApplicationConfig.getSecureMode();
        this.allowedToVisualizeMediaTypes = webApplicationConfig.getAllowedMediaTypes();
        this.dslQueryHelper = DslQueryHelper.getInstance();
        this.paginationHelper = PaginationHelper.getInstance();
    }

    @VisibleForTesting
    public WebApplicationResource(Set<String> permissions, WebApplicationConfig webApplicationConfig, IngestExternalClientFactory ingestExternalClientFactory, AdminExternalClientFactory adminExternalClientFactory, UserInterfaceTransactionManager userInterfaceTransactionManager, DslQueryHelper dslQueryHelper, PaginationHelper paginationHelper) {
        super((VitamStatusService)new BasicVitamStatusServiceImpl());
        this.permissions = permissions;
        this.ingestExternalClientFactory = ingestExternalClientFactory;
        this.adminExternalClientFactory = adminExternalClientFactory;
        this.userInterfaceTransactionManager = userInterfaceTransactionManager;
        this.secureMode = webApplicationConfig.getSecureMode();
        this.allowedToVisualizeMediaTypes = webApplicationConfig.getAllowedMediaTypes();
        this.dslQueryHelper = dslQueryHelper;
        this.paginationHelper = paginationHelper;
    }

    @GET
    @Path(value="/messages/logbook")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"messages:logbook:read"})
    public Response getLogbookMessages() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)VitamLogbookMessages.getAllMessages()).build();
    }

    @POST
    @Path(value="/archivesearch/units")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archivesearch:units:read"})
    public Response getArchiveSearchResult(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String criteria) {
        OffsetBasedPagination pagination;
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{criteria});
        try {
            Enumeration headersReqId = request.getHeaders(IhmWebAppHeader.REQUEST_ID.name());
            while (headersReqId.hasMoreElements()) {
                SanityChecker.checkParameter((String[])new String[]{(String)headersReqId.nextElement()});
            }
            pagination = new OffsetBasedPagination(request);
        }
        catch (VitamException e) {
            LOGGER.error("Bad request Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
        if (!requestIds.isEmpty()) {
            String requestId = (String)requestIds.get(0);
            try {
                RequestResponseOK result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination));
                if (!result.isOk()) {
                    return result.toResponse();
                }
                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).header("X-Request-Id", (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            catch (VitamException e) {
                LOGGER.error("Bad request Exception ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-Request-Id", (Object)requestId).build();
            }
        }
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)criteria));
            Map criteriaMap = JsonHandler.getMapFromString((String)criteria);
            JsonNode preparedQueryDsl = this.dslQueryHelper.createSelectElasticsearchDSLQuery(criteriaMap);
            RequestResponse result = this.userInterfaceTransactionManager.searchUnits(preparedQueryDsl, this.userInterfaceTransactionManager.getVitamContext(request));
            if (!result.isOk()) {
                return result.toResponse();
            }
            this.paginationHelper.setResult(sessionId, result.toJsonNode());
            result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(result.toJsonNode(), pagination));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessExternalClientNotFoundException e) {
            LOGGER.error(ACCESS_CLIENT_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/archivesearch/unit/{id}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archivesearch:units:read"})
    public Response getArchiveUnitDetails(@Context HttpServletRequest request, @PathParam(value="id") String unitId) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{unitId});
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)unitId));
            HashMap<String, String> selectUnitIdMap = new HashMap<String, String>();
            selectUnitIdMap.put("projection_", BuilderToken.GLOBAL.RULES.exactToken());
            JsonNode preparedQueryDsl = this.dslQueryHelper.createGetByIdDSLSelectMultipleQuery(selectUnitIdMap);
            RequestResponse archiveDetails = this.userInterfaceTransactionManager.getArchiveUnitDetails(preparedQueryDsl, unitId, this.userInterfaceTransactionManager.getVitamContext(request));
            return archiveDetails.toResponse();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/archivesearch/unitsWithInheritedRules/{id}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archivesearch:units:read"})
    public Response getArchiveUnitDetailsWithInheritance(@Context HttpServletRequest request, @PathParam(value="id") String unitId) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{unitId});
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)unitId));
            SelectMultiQuery select = new SelectMultiQuery();
            select.addProjection((JsonNode)JsonHandler.createObjectNode());
            if (unitId != null) {
                select.setQuery((Query)QueryHelper.eq((String)VitamFieldsHelper.id(), (String)unitId));
            }
            ObjectNode preparedQueryDsl = select.getFinalSelect();
            RequestResponse archiveDetails = this.userInterfaceTransactionManager.selectUnitsWithInheritedRules((JsonNode)preparedQueryDsl, this.userInterfaceTransactionManager.getVitamContext(request));
            return archiveDetails.toResponse();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/logbook/operations")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"logbook:operations:read"})
    public Response getLogbookResult(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        RequestResponse result;
        OffsetBasedPagination pagination;
        ParametersChecker.checkParameter((String)"cookie is mandatory", (String[])new String[]{sessionId});
        try {
            pagination = new OffsetBasedPagination(request);
            Enumeration headersReqId = request.getHeaders(IhmWebAppHeader.REQUEST_ID.name());
            while (headersReqId.hasMoreElements()) {
                SanityChecker.checkParameter((String[])new String[]{(String)headersReqId.nextElement()});
            }
        }
        catch (VitamException e) {
            LOGGER.error("Bad request Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        if (!requestIds.isEmpty()) {
            String requestId = (String)requestIds.get(0);
            try {
                RequestResponseOK result2 = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)result2).header("X-Request-Id", (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            catch (VitamException e) {
                LOGGER.error("Bad request Exception ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-Request-Id", (Object)requestId).build();
            }
        }
        String requestId = GUIDFactory.newRequestIdGUID((int)tenantId).toString();
        try {
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            Map optionsMap = JsonHandler.getMapFromString((String)options);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            result = this.userInterfaceTransactionManager.selectOperation(query, this.userInterfaceTransactionManager.getVitamContext(request));
            if (!result.isOk()) {
                return result.toResponse();
            }
            this.paginationHelper.setResult(sessionId, result.toJsonNode());
            result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(result.toJsonNode(), pagination));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Bad request Exception ", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-Request-Id", (Object)requestId).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Request-Id", (Object)requestId).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).header("X-Request-Id", (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
    }

    @POST
    @Path(value="/logbook/operations/last")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"logbook:operations:read"})
    public Response getLogbookResultLast(@Context HttpServletRequest request, JsonNode query) {
        RequestResponse result;
        try {
            SanityChecker.checkJsonAll((JsonNode)query);
            result = this.userInterfaceTransactionManager.selectOperation(query, this.userInterfaceTransactionManager.getVitamContext(request));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("Vitam Client Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/logbook/operations/{idOperation}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"logbook:operations:read"})
    public Response getLogbookResultById(@Context HttpServletRequest request, @PathParam(value="idOperation") String operationId, String options) {
        RequestResponse result;
        try {
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            result = this.userInterfaceTransactionManager.selectOperationbyId(operationId, this.userInterfaceTransactionManager.getVitamContext(request));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("Vitam Client Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="ingest/upload")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ingest:create"})
    public Response ingest(@Context HttpServletResponse response, @Context HttpServletRequest request, byte[] stream) {
        String operationGuid;
        String chunkOffset = request.getHeader(X_CHUNK_OFFSET);
        String chunkSizeTotal = request.getHeader(X_SIZE_TOTAL);
        String contextId = request.getHeader("X-Context-Id");
        String action = request.getHeader("X-ACTION");
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        if (request.getHeader("X-Request-Id") == null || request.getHeader("X-Request-Id").isEmpty()) {
            operationGuid = GUIDFactory.newGUID().getId();
            AtomicLong writtenByteSize = new AtomicLong(0L);
            this.uploadMap.put(operationGuid, writtenByteSize);
        } else {
            operationGuid = request.getHeader("X-Request-Id");
            try {
                SanityChecker.checkParameter((String[])new String[]{operationGuid});
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error("Bad request exception", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        AbstractInterruptibleChannel fileChannel = null;
        try {
            Response response2;
            RandomAccessFile randomAccessFile = new RandomAccessFile(PropertiesUtils.fileFromTmpFolder((String)operationGuid).getAbsolutePath(), "rw");
            try {
                fileChannel = randomAccessFile.getChannel();
                long offset = Long.parseLong(chunkOffset);
                int writtenByte = ((FileChannel)fileChannel).write(ByteBuffer.wrap(stream), offset);
                AtomicLong writtenByteSize = this.uploadMap.get(operationGuid);
                long total = writtenByteSize.addAndGet(writtenByte);
                long size = Long.parseLong(chunkSizeTotal);
                if (total >= size) {
                    ((FileChannel)fileChannel).force(false);
                    this.startUpload(operationGuid, tenantId, contextId, action);
                    this.uploadMap.remove(operationGuid);
                }
                response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)JsonHandler.getFromString((String)("{\"" + "X-Request-Id".toLowerCase() + "\":\"" + operationGuid + "\"}"))).header("X-Request-Id", (Object)operationGuid).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    LOGGER.error("Upload failed", (Throwable)e);
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                    return response3;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("Upload failed", (Throwable)e);
                    Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Request-Id", (Object)operationGuid).build();
                    return response4;
                }
            }
            randomAccessFile.close();
            return response2;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
            }
        }
    }

    private void startUpload(String operationGUID, Integer tenantId, String contextId, String action) {
        IngestThread ingestThread = new IngestThread(operationGUID, tenantId, contextId, action);
        ingestThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="check/{id_op}")
    @GET
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"check:read"})
    public Response checkUploadOperation(@PathParam(value="id_op") String operationId, @Context HttpServletRequest request, @QueryParam(value="action") String action) throws VitamClientException, IngestExternalException {
        ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{operationId});
        int tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        List responseDetails = (List)uploadRequestsStatus.get(operationId);
        if (responseDetails != null && responseDetails.size() >= 3 && responseDetails.get(1).equals(Response.Status.SERVICE_UNAVAILABLE)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)((String)responseDetails.get(2)).getBytes(CharsetUtils.UTF8)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header(CONTENT_DISPOSITION, (Object)("attachment; filename=ATR_" + operationId + ".xml")).header("X-Request-Id", (Object)operationId).build();
        }
        if (responseDetails == null) return Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Request-Id", (Object)operationId).build();
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            String id = responseDetails.get(0).toString();
            VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)client);
            if (vitamPoolingClient.wait(tenantId, id, 30, 1000L, TimeUnit.MILLISECONDS)) {
                RequestResponse requestResponse = client.getOperationProcessExecutionDetails(this.userInterfaceTransactionManager.getVitamContext(request), id);
                if (!requestResponse.isOk()) {
                    Response response = requestResponse.toResponse();
                    return response;
                }
                ItemStatus itemStatus = (ItemStatus)((RequestResponseOK)requestResponse).getResults().get(0);
                if (ProcessState.COMPLETED.equals((Object)itemStatus.getGlobalState())) {
                    File file = this.downloadAndSaveATR(id, request);
                    if (file == null) return Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Request-Id", (Object)operationId).build();
                    LogbookEventOperation lastEvent = this.getlogBookOperationStatus(id, request);
                    int status = WebApplicationResource.getStatus(lastEvent);
                    Response response = Response.status((int)status).entity((Object)new FileInputStream(file)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header(CONTENT_DISPOSITION, (Object)("attachment; filename=ATR_" + id + ".xml")).header("X-Request-Id", (Object)operationId).build();
                    return response;
                }
                if (ProcessState.PAUSE.equals((Object)itemStatus.getGlobalState())) {
                    Response response = Response.status((Response.Status)itemStatus.getGlobalStatus().getEquivalentHttpStatus()).build();
                    return response;
                }
                Response response = Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Request-Id", (Object)operationId).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Request-Id", (Object)operationId).build();
            return response;
        }
        catch (VitamException e) {
            LOGGER.error((Throwable)e);
            if (null == e.getVitamError()) return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Request-Id", (Object)operationId).entity((Object)e).build();
            return e.getVitamError().toResponse();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Request-Id", (Object)operationId).entity((Object)e).build();
        }
    }

    private LogbookEventOperation getlogBookOperationStatus(String operationId, HttpServletRequest request) throws VitamClientException {
        RequestResponse result = this.userInterfaceTransactionManager.selectOperationbyId(operationId, this.userInterfaceTransactionManager.getVitamContext(request));
        RequestResponseOK responseOK = (RequestResponseOK)result;
        List results = responseOK.getResults();
        LogbookOperation operation = (LogbookOperation)results.get(0);
        return (LogbookEventOperation)Iterables.getLast((Iterable)operation.getEvents());
    }

    private static int getStatus(LogbookEventOperation lastEvent) throws VitamException {
        if (lastEvent.getOutcome() == null) {
            throw new VitamException("parsing Error");
        }
        switch (lastEvent.getOutcome()) {
            case "WARNING": {
                return 206;
            }
            case "OK": {
                return 200;
            }
            case "KO": {
                return 400;
            }
        }
        return 500;
    }

    @POST
    @Path(value="/elimination/analysis")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"elimination:analysis"})
    public Response startEliminationAnalysis(@Context HttpServletRequest request, String updateSet) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateSet));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try {
            EliminationRequestBody requestBody = this.getEliminationRequestBody(updateSet);
            RequestResponse eliminationResponse = this.userInterfaceTransactionManager.startEliminationAnalysis(requestBody, this.userInterfaceTransactionManager.getVitamContext(request));
            return eliminationResponse.toResponse();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/elimination/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"elimination:action"})
    public Response startEliminationAction(@Context HttpServletRequest request, String updateSet) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateSet));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try {
            EliminationRequestBody requestBody = this.getEliminationRequestBody(updateSet);
            RequestResponse eliminationResponse = this.userInterfaceTransactionManager.startEliminationAction(requestBody, this.userInterfaceTransactionManager.getVitamContext(request));
            return eliminationResponse.toResponse();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private EliminationRequestBody getEliminationRequestBody(String updateSet) throws InvalidParseOperationException {
        JsonNode updateJsonNode = JsonHandler.getFromString((String)updateSet);
        ObjectNode query = JsonHandler.createObjectNode();
        query.set(BuilderToken.GLOBAL.ROOTS.exactToken(), (JsonNode)JsonHandler.createArrayNode());
        query.set(BuilderToken.GLOBAL.QUERY.exactToken(), updateJsonNode.get("query").get(BuilderToken.GLOBAL.QUERY.exactToken()));
        if (updateJsonNode.has("threshold") && !updateJsonNode.get("threshold").isNull()) {
            if (!updateJsonNode.get("threshold").isIntegralNumber()) {
                throw new InvalidParseOperationException("invalid request");
            }
            query.put(BuilderToken.GLOBAL.THRESOLD.exactToken(), updateJsonNode.get("threshold").longValue());
        }
        EliminationRequestBody requestBody = new EliminationRequestBody();
        requestBody.setDate(updateJsonNode.get("date").asText());
        requestBody.setDslRequest((JsonNode)query);
        return requestBody;
    }

    @POST
    @Path(value="/archiveupdate/units")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"archiveupdate:units:update"})
    public Response massiveArchiveUnitUpdate(@Context HttpServletRequest request, String updateSet) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateSet));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try {
            JsonNode modifiedFields = JsonHandler.getFromString((String)updateSet);
            ObjectNode baseQuery = this.dslQueryHelper.createMassiveUpdateDSLBaseQuery(modifiedFields);
            JsonNode rulesQuery = modifiedFields.get("rulesUpdates");
            RequestResponse metadataUpdateResponse = null;
            RequestResponse rulesUpdateResponse = null;
            UpdateMultiQuery metadataUpdate = this.dslQueryHelper.getFullMetadataActionQuery(modifiedFields.get("metadataUpdates"));
            ObjectNode metadataQuery = baseQuery.deepCopy();
            if (metadataUpdate != null) {
                metadataQuery.set(BuilderToken.GLOBAL.ACTION.exactToken(), metadataUpdate.getFinalUpdate().get(BuilderToken.GLOBAL.ACTION.exactToken()));
                metadataUpdateResponse = this.userInterfaceTransactionManager.massiveUnitsUpdate((JsonNode)metadataQuery, this.userInterfaceTransactionManager.getVitamContext(request));
            }
            if (rulesQuery != null) {
                baseQuery.remove("$action");
                ObjectNode fullRuleQuery = JsonHandler.createObjectNode();
                fullRuleQuery.set("dslRequest", (JsonNode)baseQuery);
                fullRuleQuery.set("ruleActions", rulesQuery);
                rulesUpdateResponse = this.userInterfaceTransactionManager.massiveRulesUpdate((JsonNode)fullRuleQuery, this.userInterfaceTransactionManager.getVitamContext(request));
            }
            return metadataUpdateResponse == null ? (rulesUpdateResponse == null ? Response.status((Response.Status)Response.Status.BAD_REQUEST).build() : rulesUpdateResponse.toResponse()) : metadataUpdateResponse.toResponse();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/archiveupdate/units/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"archiveupdate:units:update"})
    public Response updateArchiveUnitDetails(@Context HttpServletRequest request, @PathParam(value="id") String unitId, String updateSet) {
        try {
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{unitId});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)unitId));
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateSet));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try {
            HashMap<String, JsonNode> updateUnitIdMap = new HashMap<String, JsonNode>();
            HashMap<String, JsonNode> updateRules = new HashMap<String, JsonNode>();
            JsonNode modifiedFields = JsonHandler.getFromString((String)updateSet);
            if (modifiedFields != null && modifiedFields.isArray()) {
                for (JsonNode modifiedField : modifiedFields) {
                    if (modifiedField.get(UPDATE_RULES_KEY) != null) {
                        ArrayNode rulesCategories = (ArrayNode)modifiedField.get(UPDATE_RULES_KEY);
                        for (JsonNode ruleCategory : rulesCategories) {
                            for (String categoryKey : VitamConstants.getSupportedRules()) {
                                JsonNode rules = ruleCategory.get(categoryKey);
                                if (rules == null) continue;
                                updateRules.put(categoryKey, rules);
                            }
                        }
                        continue;
                    }
                    updateUnitIdMap.put(modifiedField.get(FIELD_ID_KEY).textValue(), modifiedField.get(NEW_FIELD_VALUE_KEY));
                }
            }
            JsonNode preparedQueryDsl = this.dslQueryHelper.createUpdateByIdDSLQuery(updateUnitIdMap, updateRules);
            RequestResponse archiveDetails = this.userInterfaceTransactionManager.updateUnits(preparedQueryDsl, unitId, this.userInterfaceTransactionManager.getVitamContext(request));
            return archiveDetails.toResponse();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/admin/formats")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:formats:read"})
    public Response getFileFormats(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            Map optionsMap = JsonHandler.getMapFromString((String)options);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse result = adminClient.findFormats(this.userInterfaceTransactionManager.getVitamContext(request), query);
            if (result != null && result instanceof RequestResponseOK) {
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                return response;
            }
            if (result != null && result instanceof VitamError) {
                LOGGER.error(result.toString());
                Response response = Response.status((int)result.getHttpCode()).entity((Object)result).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Bad request Exception ", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("AdminManagementClient NOT FOUND Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/admin/formats/{idFormat:.+}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:formats:read"})
    public Response getFormatById(@Context HttpServletRequest request, @PathParam(value="idFormat") String formatId, String options) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            ParametersChecker.checkParameter((String)"Format Id is mandatory", (String[])new String[]{formatId});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)formatId));
            RequestResponse result = adminClient.findFormatById(this.userInterfaceTransactionManager.getVitamContext(request), formatId);
            if (result != null && result instanceof RequestResponseOK) {
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                return response;
            }
            if (result != null && result instanceof VitamError) {
                LOGGER.error(result.toString());
                Response response = Response.status((int)result.getHttpCode()).entity((Object)result).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("AdminManagementClient NOT FOUND Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/format/check")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"format:check"})
    public Response checkRefFormat(@Context HttpServletRequest request, InputStream input) {
        try {
            Response response;
            block13: {
                AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();
                try {
                    Response response2;
                    response = response2 = adminClient.checkFormats(this.userInterfaceTransactionManager.getVitamContext(request), input);
                    if (adminClient == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (adminClient != null) {
                            try {
                                adminClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (VitamClientException e) {
                        LOGGER.error("VitamClientException ", (Throwable)e);
                        Response response3 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                        return response3;
                    }
                    catch (Exception e) {
                        LOGGER.error((Throwable)e);
                        Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                        return response4;
                    }
                }
                adminClient.close();
            }
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/format/upload")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"format:create"})
    public Response uploadRefFormat(@Context HttpServletRequest request, InputStream input) {
        try {
            Response response;
            block21: {
                AdminExternalClient adminClient;
                block19: {
                    Response response2;
                    block20: {
                        RequestResponse response3;
                        block17: {
                            Response response4;
                            block18: {
                                adminClient = this.adminExternalClientFactory.getClient();
                                try {
                                    response3 = adminClient.createFormats(this.userInterfaceTransactionManager.getVitamContext(request), input, request.getHeader("X-Filename"));
                                    if (response3 == null || !(response3 instanceof RequestResponseOK)) break block17;
                                    response4 = Response.status((Response.Status)Response.Status.OK).build();
                                    if (adminClient == null) break block18;
                                }
                                catch (Throwable throwable) {
                                    Response response5;
                                    try {
                                        if (adminClient != null) {
                                            try {
                                                adminClient.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (AccessExternalClientException e) {
                                        LOGGER.error("AdminManagementClient NOT FOUND Exception ", (Throwable)e);
                                        response5 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                                        return response5;
                                    }
                                    catch (Exception e) {
                                        response5 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                                        return response5;
                                    }
                                }
                                adminClient.close();
                            }
                            return response4;
                        }
                        if (response3 == null || !(response3 instanceof VitamError)) break block19;
                        LOGGER.error(response3.toString());
                        response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response3).build();
                        if (adminClient == null) break block20;
                        adminClient.close();
                    }
                    return response2;
                }
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                if (adminClient == null) break block21;
                adminClient.close();
            }
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)input);
        }
    }

    @GET
    @Path(value="/archiveunit/objects/{idOG}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archiveunit:objects:read"})
    public Response getArchiveObjectGroup(@Context HttpServletRequest request, @PathParam(value="idOG") String objectGroupId) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{objectGroupId});
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)objectGroupId));
            SelectMultiQuery select = new SelectMultiQuery();
            select.addUsedProjection(new String[]{"#qualifiers"});
            ObjectNode preparedQueryDsl = select.getFinalSelectById();
            RequestResponse searchResult = this.userInterfaceTransactionManager.selectObjectbyId((JsonNode)preparedQueryDsl, objectGroupId, this.userInterfaceTransactionManager.getVitamContext(request));
            if (searchResult.isOk()) {
                return Response.status((int)searchResult.getStatus()).entity((Object)JsonTransformer.transformResultObjects((JsonNode)searchResult.toJsonNode())).build();
            }
            return Response.status((int)searchResult.getStatus()).entity((Object)searchResult.toJsonNode()).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/archiveunit/objects/download/{unitId}")
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"archiveunit:objects:read"})
    public void getObjectAsInputStreamAsync(@PathParam(value="unitId") String unitId, @QueryParam(value="usage") String usage, @QueryParam(value="filename") String filename, @QueryParam(value="tenantId") Integer tenantId, @QueryParam(value="contractId") String contractId, @Suspended AsyncResponse asyncResponse) {
        this.threadPoolExecutor.execute(() -> this.asyncGetObjectStream(asyncResponse, unitId, usage, filename, tenantId, contractId));
    }

    @GET
    @Path(value="/ingests/{idObject}/{type}")
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"ingests:read"})
    public void getObjectFromStorageAsInputStreamAsync(@Context HttpServletRequest request, @PathParam(value="idObject") String objectId, @PathParam(value="type") String type, @Suspended AsyncResponse asyncResponse) {
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        String contractId = this.userInterfaceTransactionManager.getContractId(request);
        String personalCert = this.userInterfaceTransactionManager.getPersonalCertificate(request);
        this.threadPoolExecutor.execute(() -> this.asyncGetObjectStorageStream(asyncResponse, objectId, type, tenantId, contractId, personalCert));
    }

    private void asyncGetObjectStorageStream(AsyncResponse asyncResponse, String objectId, String type, Integer tenantId, String contractId, String personalCert) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)objectId));
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)type));
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{objectId});
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{type});
        }
        catch (InvalidParseOperationException exc) {
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            return;
        }
        catch (IllegalArgumentException exc) {
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
            return;
        }
        try (IngestExternalClient client = this.ingestExternalClientFactory.getClient();){
            IngestCollection collection = IngestCollection.valueOf((String)type.toUpperCase());
            Response response = client.downloadObjectAsync(this.userInterfaceTransactionManager.getVitamContext(tenantId, contractId, personalCert), objectId, collection);
            AsyncInputStreamHelper helper = new AsyncInputStreamHelper(asyncResponse, response);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                helper.writeResponse(Response.ok().header(CONTENT_DISPOSITION, (Object)("filename=" + objectId + ".xml")));
            } else {
                helper.writeResponse(Response.status((int)response.getStatus()));
            }
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        catch (VitamClientException exc) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    private void asyncGetObjectStream(AsyncResponse asyncResponse, String unitId, String usage, String filename, Integer tenantId, String contractId) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)unitId));
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)usage));
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)filename));
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{unitId});
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{usage});
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{filename});
        }
        catch (InvalidParseOperationException exc) {
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            return;
        }
        catch (IllegalArgumentException exc) {
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
            return;
        }
        try {
            String[] usageAndVersion = usage.split("_");
            if (usageAndVersion.length != 2) {
                throw new InvalidParameterException();
            }
            this.userInterfaceTransactionManager.getObjectAsInputStream(asyncResponse, unitId, usageAndVersion[0], Integer.parseInt(usageAndVersion[1]), filename, new VitamContext(tenantId).setAccessContract(contractId).setApplicationSessionId(this.userInterfaceTransactionManager.getAppSessionId()), this.allowedToVisualizeMediaTypes);
        }
        catch (VitamClientException exc) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        catch (Exception exc) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/admin/rules")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:rules:read"})
    public Response getFileRules(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        ParametersChecker.checkParameter((String)"cookie is mandatory", (String[])new String[]{sessionId});
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            Map optionsMap = JsonHandler.getMapFromString((String)options);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse result = adminClient.findRules(this.userInterfaceTransactionManager.getVitamContext(request), query);
            if (result != null && result instanceof RequestResponseOK) {
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                return response;
            }
            if (result != null && result instanceof VitamError) {
                LOGGER.error(result.toString());
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)result).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Bad request Exception ", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("AdminManagementClient NOT FOUND Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode())).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/admin/rules/{id_rule}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:rules:read"})
    public Response getRuleById(@Context HttpServletRequest request, @PathParam(value="id_rule") String ruleId, String options) {
        RequestResponse result = null;
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            ParametersChecker.checkParameter((String)"rule Id is mandatory", (String[])new String[]{ruleId});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)ruleId));
            result = adminClient.findRuleById(this.userInterfaceTransactionManager.getVitamContext(request), ruleId);
            if (result != null && result instanceof RequestResponseOK) {
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                return response;
            }
            if (result != null && result instanceof VitamError) {
                LOGGER.error(result.toString());
                Response response = Response.status((int)result.getHttpCode()).entity((Object)result).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("AdminManagementClient NOT FOUND Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/rules/report/download/{id}")
    @Produces(value={"application/octet-stream"})
    public Response downloadRulesReport(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try {
            File file = this.downloadReportOrCsv(id, request, JSON);
            if (file != null) {
                return Response.ok().entity((Object)new FileInputStream(file)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header(CONTENT_DISPOSITION, (Object)("attachment; filename=" + id + JSON)).build();
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/report/distribution/download/{id}")
    @Produces(value={"application/octet-stream"})
    public Response downloadDistributionReport(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try {
            SanityChecker.checkParameter((String[])new String[]{id});
            File file = this.downloadReportOrCsv(id, request, DISTRIBUTION);
            if (file != null) {
                return Response.ok().entity((Object)new FileInputStream(file)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header(CONTENT_DISPOSITION, (Object)("attachment; filename=" + id + JSON)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (InvalidParseOperationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/report/batchreport/download/{id}")
    @Produces(value={"application/octet-stream"})
    public Response downloadBatchReport(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try {
            SanityChecker.checkParameter((String[])new String[]{id});
            File file = this.downloadReportOrCsv(id, request, BATCH_REPORT);
            if (file != null) {
                return Response.ok().entity((Object)new FileInputStream(file)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header(CONTENT_DISPOSITION, (Object)("attachment; filename=" + id + JSONL)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (InvalidParseOperationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/referential/download/{id}/{type}")
    @Produces(value={"application/octet-stream"})
    public Response downloadCsvReferential(@Context HttpServletRequest request, @PathParam(value="id") String id, @PathParam(value="type") String type) {
        try {
            File file = this.downloadReportOrCsv(id, request, type);
            if (file != null) {
                return Response.ok().entity((Object)new FileInputStream(file)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header(CONTENT_DISPOSITION, (Object)("attachment; filename=" + id + CSV)).build();
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadReportOrCsv(String guid, HttpServletRequest request, String typeOfDownload) throws VitamClientException {
        File file = null;
        Response response = null;
        try (AdminExternalClient adminExternalClient = this.adminExternalClientFactory.getClient();){
            if (DISTRIBUTION.equals(typeOfDownload)) {
                response = adminExternalClient.downloadDistributionReport(this.userInterfaceTransactionManager.getVitamContext(request), guid);
                file = this.getFileFromResponse((InputStream)response.readEntity(InputStream.class), guid, JSON);
            }
            if (BATCH_REPORT.equals(typeOfDownload)) {
                response = adminExternalClient.downloadBatchReport(this.userInterfaceTransactionManager.getVitamContext(request), guid);
                file = this.getFileFromResponse((InputStream)response.readEntity(InputStream.class), guid, JSONL);
            }
            if (JSON.equals(typeOfDownload)) {
                response = adminExternalClient.downloadRulesReport(this.userInterfaceTransactionManager.getVitamContext(request), guid);
                file = this.getFileFromResponse((InputStream)response.readEntity(InputStream.class), guid, JSON);
            } else if (AGENCIES.equals(typeOfDownload)) {
                response = adminExternalClient.downloadAgenciesCsvAsStream(this.userInterfaceTransactionManager.getVitamContext(request), guid);
                file = this.getFileFromResponse((InputStream)response.readEntity(InputStream.class), guid, CSV);
            } else if (RULES.equals(typeOfDownload)) {
                response = adminExternalClient.downloadRulesCsvAsStream(this.userInterfaceTransactionManager.getVitamContext(request), guid);
                file = this.getFileFromResponse((InputStream)response.readEntity(InputStream.class), guid, CSV);
            }
        }
        catch (Throwable throwable) {
            DefaultClient.staticConsumeAnyEntityAndClose(response);
            throw throwable;
        }
        DefaultClient.staticConsumeAnyEntityAndClose((Response)response);
        return file;
    }

    private File getFileFromResponse(InputStream inputStream, String guid, String fileExtension) throws VitamClientException {
        File file = null;
        if (inputStream != null) {
            file = PropertiesUtils.fileFromTmpFolder((String)(guid + fileExtension));
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                StreamUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            catch (IOException e) {
                throw new VitamClientException("Error during Report generation");
            }
        }
        return file;
    }

    @POST
    @Path(value="/rules/check")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"rules:create"})
    public void checkRefRule(@Context HttpServletRequest request, InputStream input, @Suspended AsyncResponse asyncResponse) {
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        String contractId = this.userInterfaceTransactionManager.getContractId(request);
        String personalCert = this.userInterfaceTransactionManager.getPersonalCertificate(request);
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> this.asyncDownloadErrorReport(input, asyncResponse, tenantId, contractId, personalCert));
    }

    private void asyncDownloadErrorReport(InputStream document, AsyncResponse asyncResponse, Integer tenantId, String contractId, String personalCert) {
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            Response response = client.checkRules(this.userInterfaceTransactionManager.getVitamContext(tenantId, contractId, personalCert), document);
            AsyncInputStreamHelper helper = new AsyncInputStreamHelper(asyncResponse, response);
            Response.ResponseBuilder responseBuilder = Response.status((int)response.getStatus()).header(CONTENT_DISPOSITION, (Object)ATTACHMENT_FILENAME_ERROR_REPORT_JSON).header(CONTENT_TYPE, (Object)"application/octet-stream");
            helper.writeResponse(responseBuilder);
        }
        catch (VitamClientException exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage()).toString()).build());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).toString()).build());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/rules/upload")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"rules:create"})
    public Response uploadRefRule(@Context HttpServletRequest request, InputStream input) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createRules(this.userInterfaceTransactionManager.getVitamContext(request), input, request.getHeader("X-Filename"));
            if (response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/admin/accession-register")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:accession-register:read"})
    public Response getAccessionRegister(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        ParametersChecker.checkParameter((String)"cookie is mandatory", (String[])new String[]{sessionId});
        String requestId = null;
        RequestResponseOK result = null;
        OffsetBasedPagination pagination = null;
        try {
            pagination = new OffsetBasedPagination(request);
            Enumeration headersReqId = request.getHeaders(IhmWebAppHeader.REQUEST_ID.name());
            while (headersReqId.hasMoreElements()) {
                SanityChecker.checkParameter((String[])new String[]{(String)headersReqId.nextElement()});
            }
        }
        catch (VitamException e) {
            LOGGER.error("Bad request Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        if (!requestIds.isEmpty()) {
            requestId = (String)requestIds.get(0);
            try {
                result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).header("X-Request-Id", (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            catch (VitamException e) {
                LOGGER.error("Bad request Exception ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-Request-Id", (Object)requestId).build();
            }
        }
        requestId = GUIDFactory.newRequestIdGUID((int)tenantId).toString();
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            result = this.userInterfaceTransactionManager.findAccessionRegisterSummary(options, this.userInterfaceTransactionManager.getVitamContext(request));
            if (!result.isOk()) {
                return Response.status((Response.Status)Response.Status.fromStatusCode((int)result.getHttpCode())).entity((Object)result).build();
            }
            this.paginationHelper.setResult(sessionId, result.toJsonNode());
            result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(result.toJsonNode(), pagination));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Bad request Exception ", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessExternalClientNotFoundException e) {
            LOGGER.error("AdminManagementClient NOT FOUND Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/admin/accession-register/symbolic")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:accessionregisterssymbolic:read"})
    public Response getAccessionRegisterSymbolic(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        try {
            ParametersChecker.checkParameter((String)"cookie is mandatory", (String[])new String[]{sessionId});
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            ArrayList<String> requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
            for (String requestId : requestIds) {
                SanityChecker.checkParameter((String[])new String[]{requestId});
            }
            OffsetBasedPagination pagination = new OffsetBasedPagination(request);
            if (!requestIds.isEmpty()) {
                String requestId;
                requestId = (String)requestIds.get(0);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination))).header("X-Request-Id", (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            VitamContext vitamContext = this.userInterfaceTransactionManager.getVitamContext(request);
            RequestResponse result = this.userInterfaceTransactionManager.findAccessionRegisterSymbolic(options, vitamContext);
            if (result.isOk()) {
                JsonNode jsonResult = result.toJsonNode();
                this.paginationHelper.setResult(sessionId, jsonResult);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(jsonResult, pagination))).build();
            }
            return Response.status((Response.Status)Response.Status.fromStatusCode((int)result.getHttpCode())).entity((Object)result).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Bad request Exception ", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/admin/accession-register/{originatingAgency}/accession-register-detail")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:accession-register:read"})
    public Response getAccessionRegisterDetail(@Context HttpServletRequest request, @PathParam(value="originatingAgency") String originatingAgency, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        try {
            ParametersChecker.checkParameter((String)"cookie is mandatory", (String[])new String[]{sessionId});
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{options});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            ArrayList<String> requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
            for (String requestId : requestIds) {
                SanityChecker.checkParameter((String[])new String[]{requestId});
            }
            OffsetBasedPagination pagination = new OffsetBasedPagination(request);
            if (!requestIds.isEmpty()) {
                String requestId;
                requestId = (String)requestIds.get(0);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination))).header("X-Request-Id", (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            VitamContext vitamContext = this.userInterfaceTransactionManager.getVitamContext(request);
            RequestResponse result = this.userInterfaceTransactionManager.findAccessionRegisterDetail(originatingAgency, options, vitamContext);
            if (result.isOk()) {
                JsonNode jsonResult = result.toJsonNode();
                this.paginationHelper.setResult(sessionId, jsonResult);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(jsonResult, pagination))).build();
            }
            return Response.status((Response.Status)Response.Status.fromStatusCode((int)result.getHttpCode())).entity((Object)result).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Bad request Exception ", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/archiveunit/tree")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archiveunit:tree:read"})
    public Response getUnitTree(@Context HttpServletRequest request, JsonNode dslQuery) {
        try {
            SanityChecker.checkJsonAll((JsonNode)dslQuery);
            RequestResponse parentsDetails = this.userInterfaceTransactionManager.searchUnits(dslQuery, this.userInterfaceTransactionManager.getVitamContext(request));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)parentsDetails).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response login(@Context HttpServletRequest request, @Context HttpServletRequest httpRequest, JsonNode object) {
        Subject subject = ThreadContext.getSubject();
        String username = object.get("token").get("principal").textValue();
        String password = object.get("token").get("credentials").textValue();
        if (username == null || password == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        String tokenCSRF = XSRFHelper.generateCSRFToken();
        XSRFFilter.addToken((String)httpRequest.getSession().getId(), (String)tokenCSRF);
        try {
            subject.login((AuthenticationToken)token);
            int timeoutInSeconds = httpRequest.getSession().getMaxInactiveInterval() * 1000;
            LOGGER.info("Login success: " + username);
            List permissionsByUser = PermissionReader.filterPermission(this.permissions, (Subject)subject);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new LoginModel(username, permissionsByUser, timeoutInSeconds, tokenCSRF)).build();
        }
        catch (Exception uae) {
            LOGGER.debug("Login fail: " + username);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @GET
    @Path(value="permissions")
    @Produces(value={"application/json"})
    public Response getPermissions(@Context HttpServletRequest httpRequest) {
        Subject subject = ThreadContext.getSubject();
        int timeoutInSeconds = httpRequest.getSession().getMaxInactiveInterval() * 1000;
        String tokenCSRF = XSRFHelper.generateCSRFToken();
        XSRFFilter.addToken((String)httpRequest.getSession().getId(), (String)tokenCSRF);
        List permissionsByUser = PermissionReader.filterPermission(this.permissions, (Subject)subject);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new LoginModel((String)subject.getPrincipal(), permissionsByUser, timeoutInSeconds, tokenCSRF)).build();
    }

    @GET
    @Path(value="/logbookunitlifecycles/{id_lc}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"logbookunitlifecycles:read"})
    public Response getUnitLifeCycleById(@Context HttpServletRequest request, @PathParam(value="id_lc") String unitLifeCycleId) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{unitLifeCycleId});
        RequestResponse result = null;
        try {
            result = this.userInterfaceTransactionManager.selectUnitLifeCycleById(unitLifeCycleId, this.userInterfaceTransactionManager.getVitamContext(request));
        }
        catch (VitamClientException e) {
            LOGGER.error(LOGBOOK_CLIENT_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @GET
    @Path(value="/logbookobjectslifecycles/{id_lc}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"logbookobjectslifecycles:read"})
    public Response getObjectGroupLifeCycleById(@Context HttpServletRequest request, @PathParam(value="id_lc") String objectGroupLifeCycleId) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{objectGroupLifeCycleId});
        RequestResponse result = null;
        try {
            result = this.userInterfaceTransactionManager.selectObjectGroupLifeCycleById(objectGroupLifeCycleId, this.userInterfaceTransactionManager.getVitamContext(request));
        }
        catch (VitamClientException e) {
            LOGGER.error(LOGBOOK_CLIENT_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/operations")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"operations:read"})
    public Response listOperationsDetails(@Context HttpServletRequest request, ProcessQuery query) {
        Response response;
        block8: {
            AdminExternalClient client = this.adminExternalClientFactory.getClient();
            try {
                RequestResponse response2 = client.listOperationsDetails(this.userInterfaceTransactionManager.getVitamContext(request), query);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="operations/{id}")
    @PUT
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"operations:update"})
    public Response updateWorkFlowStatus(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        ParametersChecker.checkParameter((String)"ACTION Request must not be null", (String[])new String[]{request.getHeader("X-ACTION")});
        String xAction = request.getHeader("X-ACTION");
        int tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            RequestResponse response = client.updateOperationActionProcess(this.userInterfaceTransactionManager.getVitamContext(request), xAction, id);
            if (!response.isOk()) {
                Response response2 = response.toResponse();
                return response2;
            }
            ItemStatus itemStatusUpdate = (ItemStatus)((RequestResponseOK)response).getResults().get(0);
            String globalExecutionState = response.getHeaderString(itemStatusUpdate.getGlobalState().name());
            String globalExecutionStatus = response.getHeaderString(itemStatusUpdate.getGlobalStatus().name());
            VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)client);
            if (vitamPoolingClient.wait(tenantId, id, 2000, 3000L, TimeUnit.MILLISECONDS)) {
                RequestResponse requestResponse = client.getOperationProcessExecutionDetails(this.userInterfaceTransactionManager.getVitamContext(request), id);
                if (!requestResponse.isOk()) {
                    Response response3 = requestResponse.toResponse();
                    return response3;
                }
                ItemStatus itemStatus = (ItemStatus)((RequestResponseOK)requestResponse).getResults().get(0);
                if (!ProcessState.COMPLETED.equals((Object)itemStatus.getGlobalState())) {
                    Response response4 = Response.status((Response.Status)itemStatus.getGlobalStatus().getEquivalentHttpStatus()).header("X-Request-Id", (Object)id).header("X-Global-Execution-State", (Object)itemStatus.getGlobalState()).header("X-Global-Execution-Status", (Object)itemStatus.getGlobalStatus()).build();
                    return response4;
                }
                File file = this.downloadAndSaveATR(id, request);
                if (file != null) {
                    LogbookEventOperation lastEvent = this.getlogBookOperationStatus(id, request);
                    int status = WebApplicationResource.getStatus(lastEvent);
                    Response response5 = Response.status((int)status).entity((Object)new FileInputStream(file)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header(CONTENT_DISPOSITION, (Object)("attachment; filename=ATR_" + id + ".xml")).header("X-Request-Id", (Object)id).header("X-Global-Execution-State", (Object)itemStatus.getGlobalState()).header("X-Global-Execution-Status", (Object)itemStatus.getGlobalStatus()).build();
                    return response5;
                }
                Response response6 = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                return response6;
            }
            Response response7 = Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Global-Execution-State", (Object)globalExecutionState).header("X-Global-Execution-Status", (Object)globalExecutionStatus).header("X-Request-Id", (Object)id).build();
            return response7;
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DELETE
    @Path(value="/operations/{id}")
    @RequiresPermissions(value={"operations:delete"})
    public Response cancelProcess(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse resp = adminClient.cancelOperationProcessExecution(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (resp.isOk()) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity(((RequestResponseOK)resp).getResults().get(0)).build();
                return response2;
            }
            Response response = Response.status((int)resp.getHttpCode()).entity((Object)((VitamError)resp).getMessage()).build();
            return response;
        }
        catch (VitamClientException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/contracts")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"contracts:create"})
    public Response uploadRefContracts(@Context HttpServletRequest request, InputStream input) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createIngestContracts(this.userInterfaceTransactionManager.getVitamContext(request), input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/contracts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"contracts:read"})
    public Response findIngestContracts(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findIngestContracts(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/contracts/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"contracts:read"})
    public Response findContractsById(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findIngestContractById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/contracts/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"contracts:update"})
    public Response updateIngestContracts(@Context HttpServletRequest request, @PathParam(value="id") String contractId, JsonNode updateOptions) {
        Response response;
        block13: {
            try {
                ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{contractId});
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)contractId));
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateOptions));
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();
            try {
                if (!updateOptions.isObject()) {
                    throw new InvalidCreateOperationException("Query not valid");
                }
                Update updateRequest = new Update();
                updateRequest.addActions(new Action[]{UpdateActionHelper.set((ObjectNode)((ObjectNode)updateOptions))});
                RequestResponse archiveDetails = adminClient.updateIngestContract(this.userInterfaceTransactionManager.getVitamContext(request), contractId, (JsonNode)updateRequest.getFinalUpdateById());
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)archiveDetails).build();
                if (adminClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                    LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                catch (AccessExternalClientException e) {
                    LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
                catch (Exception e) {
                    LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            adminClient.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/accesscontracts")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"accesscontracts:create"})
    public Response uploadAccessContracts(@Context HttpServletRequest request, InputStream input) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createAccessContracts(this.userInterfaceTransactionManager.getVitamContext(request), input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/accesscontracts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"accesscontracts:read"})
    public Response findAccessContracts(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findAccessContracts(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/accesscontracts/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"accesscontracts:read"})
    public Response findAccessContract(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findAccessContractById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/accesscontracts/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"accesscontracts:update"})
    public Response updateAccessContracts(@Context HttpServletRequest request, @PathParam(value="id") String contractId, JsonNode updateOptions) {
        Response response;
        block13: {
            try {
                ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{contractId});
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)contractId));
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateOptions));
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();
            try {
                Update updateRequest = new Update();
                if (!updateOptions.isObject()) {
                    throw new InvalidCreateOperationException("Query not valid");
                }
                updateRequest.addActions(new Action[]{UpdateActionHelper.set((ObjectNode)((ObjectNode)updateOptions))});
                RequestResponse archiveDetails = adminClient.updateAccessContract(this.userInterfaceTransactionManager.getVitamContext(request), contractId, (JsonNode)updateRequest.getFinalUpdateById());
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)archiveDetails).build();
                if (adminClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                    LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                catch (AccessExternalClientException e) {
                    LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
                catch (Exception e) {
                    LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            adminClient.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/managementcontracts")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"managementcontracts:create"})
    public Response uploadManagementContracts(@Context HttpServletRequest request, InputStream input) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createManagementContracts(this.userInterfaceTransactionManager.getVitamContext(request), input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/managementcontracts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"managementcontracts:read"})
    public Response findManagementContracts(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findManagementContracts(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/managementcontracts/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"managementcontracts:read"})
    public Response findManagementContract(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findManagementContractById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/managementcontracts/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"managementcontracts:update"})
    public Response updateManagementContracts(@Context HttpServletRequest request, @PathParam(value="id") String contractId, JsonNode updateOptions) {
        Response response;
        block13: {
            try {
                ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{contractId});
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)contractId));
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateOptions));
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();
            try {
                Update updateRequest = new Update();
                if (!updateOptions.isObject()) {
                    throw new InvalidCreateOperationException("Query not valid");
                }
                updateRequest.addActions(new Action[]{UpdateActionHelper.set((ObjectNode)((ObjectNode)updateOptions))});
                RequestResponse archiveDetails = adminClient.updateManagementContract(this.userInterfaceTransactionManager.getVitamContext(request), contractId, (JsonNode)updateRequest.getFinalUpdateById());
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)archiveDetails).build();
                if (adminClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                    LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                catch (AccessExternalClientException e) {
                    LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
                catch (Exception e) {
                    LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            adminClient.close();
        }
        return response;
    }

    @POST
    @Path(value="/contexts/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"contexts:update"})
    public Response updateContexts(@Context HttpServletRequest request, @PathParam(value="id") String contextId, JsonNode updateOptions) {
        Response response;
        block13: {
            try {
                ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{contextId});
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)contextId));
                SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)updateOptions));
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();
            try {
                Update updateRequest = new Update();
                if (!updateOptions.isObject()) {
                    throw new InvalidCreateOperationException("Query not valid");
                }
                updateRequest.addActions(new Action[]{UpdateActionHelper.set((ObjectNode)((ObjectNode)updateOptions))});
                RequestResponse updateResponse = adminClient.updateContext(this.userInterfaceTransactionManager.getVitamContext(request), contextId, (JsonNode)updateRequest.getFinalUpdateById());
                LOGGER.error("update status " + updateResponse.toString());
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)updateResponse).build();
                if (adminClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                    LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                catch (AccessExternalClientException e) {
                    LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
                catch (Exception e) {
                    LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            adminClient.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/contexts")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"contexts:create"})
    public Response uploadContext(@Context HttpServletRequest request, InputStream input) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createContexts(this.userInterfaceTransactionManager.getVitamContext(request), input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/contexts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"contexts:read"})
    public Response findContext(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findContexts(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/contexts/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"contexts:read"})
    public Response findContextByID(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findContextById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/profiles")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"profiles:create"})
    public Response createProfilesMetadata(@Context HttpServletRequest request, InputStream input) throws IOException {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createProfiles(this.userInterfaceTransactionManager.getVitamContext(request), input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Path(value="/profiles/{id}")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"profiles:create"})
    public Response importProfileFile(@Context HttpServletRequest request, InputStream input, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createProfileFile(this.userInterfaceTransactionManager.getVitamContext(request), id, input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Path(value="/profiles/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"profiles:update"})
    public Response updateProfile(@Context HttpServletRequest request, @PathParam(value="id") String profileMetadataId, JsonNode updateOptions) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            Update updateRequest = new Update();
            if (!updateOptions.isObject()) {
                throw new InvalidCreateOperationException("Query not valid");
            }
            updateRequest.addActions(new Action[]{UpdateActionHelper.set((ObjectNode)((ObjectNode)updateOptions))});
            RequestResponse response = adminClient.updateProfile(this.userInterfaceTransactionManager.getVitamContext(request), profileMetadataId, (JsonNode)updateRequest.getFinalUpdateById());
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/profiles/{id}")
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"profiles:read"})
    public void downloadProfileFile(@Context HttpServletRequest request, @PathParam(value="id") String profileMetadataId, @Suspended AsyncResponse asyncResponse) {
        ParametersChecker.checkParameter((String)"Profile id should be filled", (String[])new String[]{profileMetadataId});
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        String contractId = this.userInterfaceTransactionManager.getContractId(request);
        String personalCert = this.userInterfaceTransactionManager.getPersonalCertificate(request);
        this.threadPoolExecutor.execute(() -> this.asyncDownloadProfileFile(profileMetadataId, asyncResponse, tenantId, contractId, personalCert));
    }

    private void asyncDownloadProfileFile(String profileMetadataId, AsyncResponse asyncResponse, Integer tenantId, String contractId, String personalCert) {
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            Response response = client.downloadProfileFile(this.userInterfaceTransactionManager.getVitamContext(tenantId, contractId, personalCert), profileMetadataId);
            AsyncInputStreamHelper helper = new AsyncInputStreamHelper(asyncResponse, response);
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK).header(CONTENT_DISPOSITION, (Object)response.getHeaderString(CONTENT_DISPOSITION)).type(response.getMediaType());
            helper.writeResponse(responseBuilder);
        }
        catch (AccessExternalNotFoundException exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorEntity(Response.Status.NOT_FOUND, exc.getMessage()).toString()).build());
        }
        catch (AccessExternalClientException exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage()).toString()).build());
        }
    }

    private VitamError getErrorEntity(Response.Status status, String msgErr) {
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(msgErr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/profiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"profiles:read"})
    public Response findProfiles(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findProfiles(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/profiles/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"profiles:read"})
    public Response findProfileByID(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findProfileById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadAndSaveATR(String guid, HttpServletRequest request) throws VitamClientException {
        Response response;
        File file;
        block15: {
            file = null;
            response = null;
            try (IngestExternalClient ingestExternalClient = this.ingestExternalClientFactory.getClient();){
                response = ingestExternalClient.downloadObjectAsync(this.userInterfaceTransactionManager.getVitamContext(request), guid, IngestCollection.ARCHIVETRANSFERREPLY);
                InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                if (inputStream == null) break block15;
                file = PropertiesUtils.fileFromTmpFolder((String)("ATR_" + guid + ".xml"));
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    StreamUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                }
                catch (IOException e) {
                    throw new VitamClientException("Error during ATR generation");
                }
            }
            catch (Throwable throwable) {
                DefaultClient.staticConsumeAnyEntityAndClose(response);
                throw throwable;
            }
        }
        DefaultClient.staticConsumeAnyEntityAndClose((Response)response);
        return file;
    }

    @POST
    @Path(value="/traceability/check")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"traceability:check:create"})
    public Response checkOperationTraceability(@Context HttpServletRequest request, String operationCriteria) {
        try {
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{operationCriteria});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)operationCriteria));
            Map optionsMap = JsonHandler.getMapFromString((String)operationCriteria);
            JsonNode dslQuery = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse result = this.userInterfaceTransactionManager.checkTraceabilityOperation(dslQuery, this.userInterfaceTransactionManager.getVitamContext(request));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (AccessExternalClientServerException e) {
            LOGGER.error(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ServiceName.VITAM.getName()).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ServiceName.VITAM.getName()).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ServiceName.VITAM.getName()).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/traceability/{idOperation}/content")
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"traceability:content:read"})
    public void downloadTraceabilityFile(@Context HttpServletRequest request, @PathParam(value="idOperation") String operationId, @QueryParam(value="contractId") String contractId, @QueryParam(value="tenantId") String tenantIdParam, @Suspended AsyncResponse asyncResponse) {
        ParametersChecker.checkParameter((String)"Operation Id should be filled", (String[])new String[]{operationId});
        Integer tenantId = tenantIdParam != null && StringUtils.isNumeric((String)tenantIdParam) ? Integer.valueOf(Integer.parseInt(tenantIdParam)) : this.userInterfaceTransactionManager.getTenantId(request);
        String personalCert = this.userInterfaceTransactionManager.getPersonalCertificate(request);
        this.threadPoolExecutor.execute(() -> this.downloadTraceabilityFileAsync(asyncResponse, operationId, tenantId, contractId, personalCert));
    }

    private void downloadTraceabilityFileAsync(AsyncResponse asyncResponse, String operationId, Integer tenantId, String contractId, String personalCert) {
        Response response = null;
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            response = client.downloadTraceabilityOperationFile(this.userInterfaceTransactionManager.getVitamContext(tenantId, contractId, personalCert), operationId);
            AsyncInputStreamHelper helper = new AsyncInputStreamHelper(asyncResponse, response);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                helper.writeResponse(Response.ok().header(CONTENT_DISPOSITION, (Object)response.getHeaderString(CONTENT_DISPOSITION)));
            } else {
                helper.writeResponse(Response.status((int)response.getStatus()));
            }
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        catch (AccessExternalClientServerException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        catch (AccessUnauthorizedException e) {
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    @POST
    @Path(value="/traceability/extractTimestamp")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"logbook:operations:read"})
    public Response extractTimeStampInformation(String timestamp) {
        try {
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{timestamp});
            Map optionsMap = JsonHandler.getMapStringFromString((String)timestamp);
            if (optionsMap.get("timestamp") != null) {
                JsonNode jsonNode = this.userInterfaceTransactionManager.extractInformationFromTimestamp((String)optionsMap.get("timestamp"));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonNode).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (BadRequestException | InvalidParseOperationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/workflows")
    @Produces(value={"application/json"})
    public Response getWorkflowDefinitions(@Context HttpServletRequest request) {
        Response response;
        block8: {
            AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();
            try {
                RequestResponse result = adminClient.getWorkflowDefinitions(this.userInterfaceTransactionManager.getVitamContext(request));
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (adminClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            adminClient.close();
        }
        return response;
    }

    @POST
    @Path(value="/audits")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"admin:audit"})
    public Response launchAudit(@Context HttpServletRequest request, JsonNode auditOption) {
        Response response;
        block8: {
            AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();
            try {
                RequestResponse result = adminClient.launchAudit(this.userInterfaceTransactionManager.getVitamContext(request), auditOption);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (adminClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            adminClient.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/agencies")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"agencies:create"})
    public Response uploadServiceAgencies(@Context HttpServletRequest request, InputStream input) {
        try {
            Response response;
            block21: {
                AdminExternalClient adminClient;
                block19: {
                    Response response2;
                    block20: {
                        RequestResponse response3;
                        block17: {
                            Response response4;
                            block18: {
                                adminClient = this.adminExternalClientFactory.getClient();
                                try {
                                    response3 = adminClient.createAgencies(this.userInterfaceTransactionManager.getVitamContext(request), input, request.getHeader("X-Filename"));
                                    if (response3 == null || !(response3 instanceof RequestResponseOK)) break block17;
                                    response4 = Response.status((Response.Status)Response.Status.OK).build();
                                    if (adminClient == null) break block18;
                                }
                                catch (Throwable throwable) {
                                    Response response5;
                                    try {
                                        if (adminClient != null) {
                                            try {
                                                adminClient.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (AccessExternalClientException e) {
                                        LOGGER.error("AdminManagementClient NOT FOUND Exception ", (Throwable)e);
                                        response5 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                                        return response5;
                                    }
                                    catch (Exception e) {
                                        LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
                                        response5 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                                        return response5;
                                    }
                                }
                                adminClient.close();
                            }
                            return response4;
                        }
                        if (response3 == null || !(response3 instanceof VitamError)) break block19;
                        LOGGER.error(response3.toString());
                        response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response3).build();
                        if (adminClient == null) break block20;
                        adminClient.close();
                    }
                    return response2;
                }
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                if (adminClient == null) break block21;
                adminClient.close();
            }
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)input);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/agencies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"agencies:read"})
    public Response findServiceAgencies(@Context HttpServletRequest request, String select) {
        try {
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{select});
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findAgencies(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/agencies/{id:.+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"agencies:read"})
    public Response findServiceAgencyById(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{id});
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findAgencyByID(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/archiveunitprofiles")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archiveunitprofiles:create"})
    public Response createArchiveUnitProfileMetadata(@Context HttpServletRequest request, InputStream input) throws IOException {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.createArchiveUnitProfile(this.userInterfaceTransactionManager.getVitamContext(request), input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Path(value="/archiveunitprofiles/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archiveunitprofiles:update"})
    public Response updateArchiveUnitProfile(@Context HttpServletRequest request, @PathParam(value="id") String archiveUnitprofileId, JsonNode updateOptions) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            Update updateRequest = new Update();
            if (!updateOptions.isObject()) {
                throw new InvalidCreateOperationException("Query not valid");
            }
            updateRequest.addActions(new Action[]{UpdateActionHelper.set((ObjectNode)((ObjectNode)updateOptions))});
            RequestResponse response = adminClient.updateArchiveUnitProfile(this.userInterfaceTransactionManager.getVitamContext(request), archiveUnitprofileId, (JsonNode)updateRequest.getFinalUpdateById());
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/archiveunitprofiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archiveunitprofiles:read"})
    public Response findArchiveUnitProfiles(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findArchiveUnitProfiles(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/archiveunitprofiles/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"archiveunitprofiles:read"})
    public Response findArchiveUnitProfileByID(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findArchiveUnitProfileById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/ontologies")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ontologies:create"})
    public Response importOntologies(@HeaderParam(value="Force-Update") boolean forceUpdate, @Context HttpServletRequest request, InputStream input) throws IOException {
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.importOntologies(forceUpdate, this.userInterfaceTransactionManager.getVitamContext(request), input);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/ontologies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ontologies:read"})
    public Response findOntologies(@Context HttpServletRequest request, String select) {
        try {
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{select});
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
                RequestResponse response = adminClient.findOntologies(this.userInterfaceTransactionManager.getVitamContext(request), query);
                if (response != null && response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response != null && response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/ontologies/{id:.+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ontologies:read"})
    public Response findOntologyById(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{id});
        try (AdminExternalClient adminClient = this.adminExternalClientFactory.getClient();){
            RequestResponse response = adminClient.findOntologyById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response != null && response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response != null && response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/archiveunit/evidenceaudit")
    @RequiresPermissions(value={"evidenceaudit:check"})
    public Response launchEvidanceAudit(@Context HttpServletRequest request, String criteria) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{criteria});
        try {
            JsonNode queryDSL = JsonHandler.getFromString((String)criteria);
            RequestResponse response = this.userInterfaceTransactionManager.evidenceAudit(queryDSL, this.userInterfaceTransactionManager.getVitamContext(request));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="/archiveunit/probativevalueexport")
    @RequiresPermissions(value={"probativevalue:check"})
    public Response exportProbativeValue(@Context HttpServletRequest request, String criteria) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{criteria});
        try {
            ProbativeValueRequest queryDSL = (ProbativeValueRequest)JsonHandler.getFromString((String)criteria, ProbativeValueRequest.class);
            RequestResponse response = this.userInterfaceTransactionManager.exportProbativeValue(queryDSL, this.userInterfaceTransactionManager.getVitamContext(request));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="/archiveunit/dipexport")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"dipexportv2:create"})
    public Response createDIPForExport(@Context HttpServletRequest request, DipRequest criteria) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (Object[])new Object[]{criteria});
        try {
            RequestResponse response = this.userInterfaceTransactionManager.exportDIP(criteria, this.userInterfaceTransactionManager.getVitamContext(request));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/archiveunit/transfers")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"transfers:create"})
    public Response createTransferSIP(@Context HttpServletRequest request, TransferRequest criteria) {
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (Object[])new Object[]{criteria});
        try {
            RequestResponse response = this.userInterfaceTransactionManager.transferSIP(criteria, this.userInterfaceTransactionManager.getVitamContext(request));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/archiveunit/dipexport/{id}")
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"dipexport:read"})
    public void getDIPAsInputStreamAsync(@Context HttpServletRequest request, @PathParam(value="id") String id, @Suspended AsyncResponse asyncResponse) {
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        String contractId = this.userInterfaceTransactionManager.getContractId(request);
        String personalCert = this.userInterfaceTransactionManager.getPersonalCertificate(request);
        this.threadPoolExecutor.execute(() -> this.asyncGetExtportStream(asyncResponse, id, tenantId, contractId, personalCert, false));
    }

    @GET
    @Path(value="/archiveunit/transfers/{id}")
    @Produces(value={"application/octet-stream"})
    @RequiresPermissions(value={"transfers:read"})
    public void getTransferSIPAsInputStreamAsync(@Context HttpServletRequest request, @PathParam(value="id") String id, @Suspended AsyncResponse asyncResponse) {
        Integer tenantId = this.userInterfaceTransactionManager.getTenantId(request);
        String contractId = this.userInterfaceTransactionManager.getContractId(request);
        String personalCert = this.userInterfaceTransactionManager.getPersonalCertificate(request);
        this.threadPoolExecutor.execute(() -> this.asyncGetExtportStream(asyncResponse, id, tenantId, contractId, personalCert, true));
    }

    private void asyncGetExtportStream(AsyncResponse asyncResponse, String dipId, Integer tenantId, String contracId, String personalCert, boolean isTransfer) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)dipId));
            ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{dipId});
        }
        catch (InvalidParseOperationException exc) {
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            return;
        }
        catch (IllegalArgumentException exc) {
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
            return;
        }
        try {
            this.userInterfaceTransactionManager.downloadExports(asyncResponse, dipId, this.userInterfaceTransactionManager.getVitamContext(tenantId, contracId, personalCert), isTransfer);
        }
        catch (VitamClientException exc) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        catch (Exception exc) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    @POST
    @Path(value="/archiveunit/computedinheritedrules")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"archiveupdate:units:update"})
    public Response computedInheritedRules(@Context HttpServletRequest request, String Query2) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)Query2));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try {
            JsonNode idFields = JsonHandler.getFromString((String)Query2);
            RequestResponse metadataUpdateResponse = this.userInterfaceTransactionManager.computinheritedrules(idFields, this.userInterfaceTransactionManager.getVitamContext(request));
            if (metadataUpdateResponse == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return metadataUpdateResponse.toResponse();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/archiveunit/deletecomputedinheritedrules")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"archiveupdate:units:update"})
    public Response deleteComputedInheritedRules(@Context HttpServletRequest request, String Query2) {
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)Query2));
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        try {
            JsonNode idFields = JsonHandler.getFromString((String)Query2);
            RequestResponse metadataUpdateResponse = this.userInterfaceTransactionManager.deleteComputedInheritedRules(idFields, this.userInterfaceTransactionManager.getVitamContext(request));
            if (metadataUpdateResponse == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return metadataUpdateResponse.toResponse();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/securemode")
    @Produces(value={"application/json"})
    public Response getSecureMode() {
        return Response.status((Response.Status)Response.Status.OK).entity(this.secureMode).build();
    }

    @GET
    @Path(value="/admintenant")
    @Produces(value={"application/json"})
    public Response getAdminTenant() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)VitamConfiguration.getAdminTenant()).build();
    }

    @POST
    @Path(value="/objectssearch/objects")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"objects:read"})
    public Response getObjectsSearchResult(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String criteria) {
        OffsetBasedPagination pagination;
        ParametersChecker.checkParameter((String)SEARCH_CRITERIA_MANDATORY_MSG, (String[])new String[]{criteria});
        try {
            Enumeration headersReqId = request.getHeaders(IhmWebAppHeader.REQUEST_ID.name());
            while (headersReqId.hasMoreElements()) {
                SanityChecker.checkParameter((String[])new String[]{(String)headersReqId.nextElement()});
            }
            pagination = new OffsetBasedPagination(request);
        }
        catch (VitamException e) {
            LOGGER.error("Bad request Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
        if (!requestIds.isEmpty()) {
            String requestId = (String)requestIds.get(0);
            try {
                RequestResponseOK result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination));
                if (!result.isOk()) {
                    return result.toResponse();
                }
                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).header("X-Request-Id", (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            catch (VitamException e) {
                LOGGER.error("Bad request Exception ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-Request-Id", (Object)requestId).build();
            }
        }
        try {
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)criteria));
            Map criteriaMap = JsonHandler.getMapFromString((String)criteria);
            JsonNode preparedQueryDsl = this.dslQueryHelper.createSelectElasticsearchDSLQuery(criteriaMap);
            RequestResponse result = this.userInterfaceTransactionManager.searchObjects(preparedQueryDsl, this.userInterfaceTransactionManager.getVitamContext(request));
            if (!result.isOk()) {
                return result.toResponse();
            }
            ArrayNode results = (ArrayNode)result.toJsonNode().get("$results");
            if (results != null && results.size() > 0) {
                StringBuilder unitsTitleCriteria = new StringBuilder();
                unitsTitleCriteria.append("{\"$roots\": [],\"$query\": [{\"$in\": {\"#object\": [");
                for (JsonNode res : results) {
                    unitsTitleCriteria.append(res.get("#id").toString()).append(",");
                }
                unitsTitleCriteria.deleteCharAt(unitsTitleCriteria.length() - 1);
                unitsTitleCriteria.append("]}}],\"$filter\": {\"$limit\": 10000},\"$projection\": {\"$fields\": {\"Title\": 1,\"#object\": 1}},\"$facets\": []}");
                ObjectMapper mapper = new ObjectMapper();
                JsonNode preparedQueryDslUnits = mapper.readTree(unitsTitleCriteria.toString());
                RequestResponse resultUnits = this.userInterfaceTransactionManager.searchUnits(preparedQueryDslUnits, this.userInterfaceTransactionManager.getVitamContext(request));
                if (resultUnits.isOk()) {
                    ArrayNode resultsUnits = (ArrayNode)resultUnits.toJsonNode().get("$results");
                    for (JsonNode resU : resultsUnits) {
                        String currentObjectId = resU.get("#object").toString();
                        for (JsonNode res : results) {
                            if (!currentObjectId.equals(res.get("#id").toString())) continue;
                            if (res.get("UnitsTitle") != null) {
                                ((ArrayNode)res.get("UnitsTitle")).add(resU.get("Title"));
                                continue;
                            }
                            ((ObjectNode)res).putArray("UnitsTitle").add(resU.get("Title"));
                        }
                    }
                }
            }
            ObjectNode finalResult = (ObjectNode)result.toJsonNode();
            finalResult.putArray("$results").addAll(results);
            this.paginationHelper.setResult(sessionId, (JsonNode)finalResult);
            result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult((JsonNode)finalResult, pagination));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AccessExternalClientNotFoundException e) {
            LOGGER.error(ACCESS_CLIENT_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (VitamClientException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    class IngestThread
    extends Thread {
        String operationGuidFirstLevel;
        Integer tenantId;
        String contextId;
        String action;

        IngestThread(String operationGuidFirstLevel, Integer tenantId, String contextId, String action) {
            this.operationGuidFirstLevel = operationGuidFirstLevel;
            this.tenantId = tenantId;
            this.contextId = contextId;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File temporarSipFile = PropertiesUtils.fileFromTmpFolder((String)this.operationGuidFirstLevel);
            try (IngestExternalClient client = WebApplicationResource.this.ingestExternalClientFactory.getClient();
                 FileInputStream fileInputStream = new FileInputStream(temporarSipFile);){
                String responseString;
                RequestResponse finalResponse = client.ingest(new VitamContext(this.tenantId).setApplicationSessionId(WebApplicationResource.this.userInterfaceTransactionManager.getAppSessionId()), (InputStream)fileInputStream, this.contextId, this.action);
                int responseStatus = finalResponse.getHttpCode();
                String guid = finalResponse.getHeaderString("X-Request-Id");
                ArrayList<String> finalResponseDetails = new ArrayList<String>();
                finalResponseDetails.add(guid);
                finalResponseDetails.add((String)Response.Status.fromStatusCode((int)responseStatus));
                if (Response.Status.SERVICE_UNAVAILABLE.getStatusCode() == finalResponse.getHttpCode() && (responseString = ((VitamError)finalResponse).getMessage()) != null) {
                    finalResponseDetails.add(responseString);
                }
                uploadRequestsStatus.put(this.operationGuidFirstLevel, finalResponseDetails);
            }
            catch (VitamException | IOException e) {
                LOGGER.error("Upload failed", e);
                ArrayList<String> finalResponseDetails = new ArrayList<String>();
                finalResponseDetails.add(this.operationGuidFirstLevel);
                finalResponseDetails.add((String)Response.Status.INTERNAL_SERVER_ERROR);
                uploadRequestsStatus.put(this.operationGuidFirstLevel, finalResponseDetails);
            }
            finally {
                try {
                    Files.delete(temporarSipFile.toPath());
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }
    }
}

