/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.client;

import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.security.internal.client.InternalSecurityClient;
import fr.gouv.vitam.security.internal.common.exception.IdentityNotFoundException;
import fr.gouv.vitam.security.internal.common.exception.InternalSecurityException;
import fr.gouv.vitam.security.internal.common.model.IdentityModel;
import fr.gouv.vitam.security.internal.common.model.IsPersonalCertificateRequiredModel;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class InternalSecurityClientRest
extends DefaultClient
implements InternalSecurityClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(InternalSecurityClientRest.class);

    public InternalSecurityClientRest(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    @Override
    public Optional<IdentityModel> findIdentity(byte[] certificate) throws VitamClientInternalException, InternalSecurityException {
        Optional<IdentityModel> optional;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/identity/").withBody((Object)certificate, "Certificate not found").withContentType(MediaType.APPLICATION_OCTET_STREAM_TYPE).withJsonAccept());
            try {
                this.check(response);
                optional = Optional.of((IdentityModel)response.readEntity(IdentityModel.class));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IdentityNotFoundException e) {
                    return Optional.empty();
                }
            }
            response.close();
        }
        return optional;
    }

    @Override
    public void checkIdentityExpiration() throws VitamClientInternalException, InternalSecurityException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/identity/check-expiration").withJsonAccept());){
            this.check(response);
        }
    }

    @Override
    public void checkPersonalCertificateExpiration() throws VitamClientInternalException, InternalSecurityException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/personalCertificate/check-expiration").withJsonAccept());){
            this.check(response);
        }
    }

    @Override
    public boolean contextIsUsed(String contextId) throws VitamClientInternalException, InternalSecurityException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/identity/context/" + contextId).withJsonAccept());){
            this.check(response);
            boolean bl = (Boolean)response.readEntity(Boolean.class);
            return bl;
        }
    }

    @Override
    public IsPersonalCertificateRequiredModel isPersonalCertificateRequiredByPermission(String permission) throws VitamClientInternalException, InternalSecurityException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/personalCertificate/permission-check/" + permission).withJsonAccept());){
            this.check(response);
            IsPersonalCertificateRequiredModel isPersonalCertificateRequiredModel = (IsPersonalCertificateRequiredModel)response.readEntity(IsPersonalCertificateRequiredModel.class);
            return isPersonalCertificateRequiredModel;
        }
    }

    @Override
    public void checkPersonalCertificate(byte[] certificate, String permission) throws VitamClientInternalException, InternalSecurityException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/personalCertificate/personal-certificate-check/" + permission).withBody((Object)certificate, "Certificate not found").withContentType(MediaType.APPLICATION_OCTET_STREAM_TYPE).withJsonAccept());){
            this.check(response);
        }
        catch (IllegalArgumentException e) {
            throw new InternalSecurityException((Throwable)e);
        }
    }

    private void check(Response response) throws InternalSecurityException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        String message = (String)response.readEntity(String.class);
        if (status == Response.Status.NOT_FOUND) {
            throw new IdentityNotFoundException(status + "-" + message);
        }
        throw new InternalSecurityException(status + "-" + message);
    }
}

