/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AccessExternalClientFactory;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.access.external.client.v2.AccessExternalClientV2;
import fr.gouv.vitam.access.external.client.v2.AccessExternalClientV2Factory;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientNotFoundException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSummaryModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSymbolicModel;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.export.dip.DipRequest;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitam.common.model.logbook.LogbookLifecycle;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.server.application.AsyncInputStreamHelper;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.ihmdemo.core.DslQueryHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;

public class UserInterfaceTransactionManager {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UserInterfaceTransactionManager.class);
    private final AccessExternalClientFactory accessExternalClientFactory;
    private final AdminExternalClientFactory adminExternalClientFactory;
    private final AccessExternalClientV2Factory accessExternalClientV2Factory;
    private final DslQueryHelper dslQueryHelper;
    private static final UserInterfaceTransactionManager instance = new UserInterfaceTransactionManager();

    public UserInterfaceTransactionManager() {
        this(AccessExternalClientFactory.getInstance(), AdminExternalClientFactory.getInstance(), AccessExternalClientV2Factory.getInstance(), DslQueryHelper.getInstance());
    }

    public static UserInterfaceTransactionManager getInstance() {
        return instance;
    }

    @VisibleForTesting
    public UserInterfaceTransactionManager(AccessExternalClientFactory accessExternalClientFactory, AdminExternalClientFactory adminExternalClientFactory, AccessExternalClientV2Factory accessExternalClientV2Factory, DslQueryHelper dslQueryHelper) {
        this.accessExternalClientFactory = accessExternalClientFactory;
        this.adminExternalClientFactory = adminExternalClientFactory;
        this.accessExternalClientV2Factory = accessExternalClientV2Factory;
        this.dslQueryHelper = dslQueryHelper;
    }

    public RequestResponse<JsonNode> searchUnits(JsonNode parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectUnits(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> searchObjects(JsonNode parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectObjects(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> getArchiveUnitDetails(JsonNode preparedDslQuery, String unitId, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectUnitbyId(context, preparedDslQuery, unitId);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> selectUnitsWithInheritedRules(JsonNode preparedDslQuery, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectUnitsWithInheritedRules(context, preparedDslQuery);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> startEliminationAnalysis(EliminationRequestBody parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.startEliminationAnalysis(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> startEliminationAction(EliminationRequestBody parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.startEliminationAction(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> massiveUnitsUpdate(JsonNode parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.massUpdateUnits(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> computinheritedrules(JsonNode parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.computedInheritedRules(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> deleteComputedInheritedRules(JsonNode parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.deleteComputedInheritedRules(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> massiveRulesUpdate(JsonNode parameters, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.massUpdateUnitsRules(context, parameters);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> updateUnits(JsonNode parameters, String unitId, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.updateUnitbyId(context, parameters, unitId);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> selectObjectbyId(JsonNode preparedDslQuery, String objectId, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectObjectMetadatasByUnitId(context, preparedDslQuery, objectId);
            return requestResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getObjectAsInputStream(AsyncResponse asyncResponse, String unitId, String usage, int version, String filename, VitamContext context, List<MediaType> allowedMediaTypes) throws UnsupportedEncodingException, VitamClientException {
        Response response = null;
        String downloadMethod = "attachment";
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            response = client.getObjectStreamByUnitId(context, unitId, usage, version);
            AsyncInputStreamHelper helper = new AsyncInputStreamHelper(asyncResponse, response);
            if (UserInterfaceTransactionManager.isAllowedToVisualize(allowedMediaTypes, response.getMediaType())) {
                downloadMethod = "inline";
            }
            Response.ResponseBuilder responseBuilder = Response.status((int)response.getStatus()).header("X-Qualifier", (Object)response.getHeaderString("X-Qualifier")).header("X-Version", (Object)response.getHeaderString("X-Version")).header("Content-Disposition", (Object)(downloadMethod + "; filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\"")).type(response.getMediaType());
            helper.writeResponse(responseBuilder);
        }
        finally {
            if (response != null && response.getStatus() != Response.Status.OK.getStatusCode()) {
                try {
                    Object object;
                    if (response.hasEntity() && (object = response.getEntity()) instanceof InputStream) {
                        StreamUtils.closeSilently((InputStream)((InputStream)object));
                    }
                }
                catch (IllegalStateException | ProcessingException e) {
                    LOGGER.debug(e);
                }
                finally {
                    response.close();
                }
            }
        }
        return true;
    }

    private static boolean isAllowedToVisualize(List<MediaType> allowedMediaTypes, MediaType mediaType) {
        if (allowedMediaTypes == null || mediaType == null) {
            return false;
        }
        for (MediaType amt : allowedMediaTypes) {
            if (!amt.getType().equals(mediaType.getType()) || !amt.getSubtype().equals(mediaType.getSubtype())) continue;
            return true;
        }
        return false;
    }

    public RequestResponse<LogbookLifecycle> selectUnitLifeCycleById(String unitLifeCycleId, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectUnitLifeCycleById(context, unitLifeCycleId, (JsonNode)new Select().getFinalSelectById());
            return requestResponse;
        }
    }

    public RequestResponse<LogbookOperation> selectOperation(JsonNode query, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectOperations(context, query);
            return requestResponse;
        }
    }

    public RequestResponse<LogbookOperation> selectOperationbyId(String operationId, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectOperationbyId(context, operationId, (JsonNode)new Select().getFinalSelectById());
            return requestResponse;
        }
    }

    public RequestResponse<LogbookLifecycle> selectObjectGroupLifeCycleById(String objectGroupLifeCycleId, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.selectObjectGroupLifeCycleById(context, objectGroupLifeCycleId, (JsonNode)new Select().getFinalSelectById());
            return requestResponse;
        }
    }

    public RequestResponse<AccessionRegisterSummaryModel> findAccessionRegisterSummary(String options, VitamContext context) throws VitamClientException, InvalidParseOperationException, InvalidCreateOperationException {
        try (AdminExternalClient adminExternalClient = this.adminExternalClientFactory.getClient();){
            Map optionsMap = JsonHandler.getMapFromString((String)options);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse requestResponse = adminExternalClient.findAccessionRegister(context, query);
            return requestResponse;
        }
    }

    public RequestResponse<AccessionRegisterSymbolicModel> findAccessionRegisterSymbolic(String options, VitamContext context) throws VitamClientException, InvalidParseOperationException, InvalidCreateOperationException {
        try (AdminExternalClient adminExternalClient = this.adminExternalClientFactory.getClient();){
            Map optionsMap = JsonHandler.getMapFromString((String)options);
            JsonNode query = optionsMap.containsKey("startDate") ? this.dslQueryHelper.createSearchQueryAccessionRegister(optionsMap) : this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse requestResponse = adminExternalClient.findAccessionRegisterSymbolic(context, query);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> findAccessionRegisterDetail(String originatingAgency, String options, VitamContext context) throws InvalidParseOperationException, AccessExternalClientServerException, AccessExternalClientNotFoundException, InvalidCreateOperationException {
        try (AdminExternalClient adminExternalClient = this.adminExternalClientFactory.getClient();){
            Map optionsMap = JsonHandler.getMapFromString((String)options);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse requestResponse = adminExternalClient.getAccessionRegisterDetail(context, originatingAgency, query);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> checkTraceabilityOperation(JsonNode query, VitamContext context) throws AccessExternalClientServerException, InvalidParseOperationException, AccessUnauthorizedException {
        try (AdminExternalClient adminExternalClient = this.adminExternalClientFactory.getClient();){
            RequestResponse requestResponse = adminExternalClient.checkTraceabilityOperation(context, query);
            return requestResponse;
        }
    }

    public JsonNode extractInformationFromTimestamp(String timestamp) throws BadRequestException {
        ObjectNode result = JsonHandler.createObjectNode();
        try {
            ASN1InputStream bIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(Base64.decode((byte[])timestamp.getBytes())));
            ASN1Primitive obj = bIn.readObject();
            TimeStampResponse tsResp = new TimeStampResponse(obj.toASN1Primitive().getEncoded());
            SignerId signerId = tsResp.getTimeStampToken().getSID();
            X500Name signerCertIssuer = signerId.getIssuer();
            result.put("genTime", LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)tsResp.getTimeStampToken().getTimeStampInfo().getGenTime())));
            result.put("signerCertIssuer", signerCertIssuer.toString());
        }
        catch (IOException | TSPException | DecoderException e) {
            LOGGER.error("Error while transforming timestamp", e);
            throw new BadRequestException("Error while transforming timestamp", e);
        }
        return result;
    }

    public RequestResponse evidenceAudit(JsonNode query, VitamContext context) throws VitamClientException {
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.evidenceAudit(context, query);
            return requestResponse;
        }
    }

    public RequestResponse exportProbativeValue(ProbativeValueRequest request, VitamContext context) throws VitamClientException {
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.exportProbativeValue(context, request);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> exportDIP(DipRequest dipRequest, VitamContext context) throws VitamClientException {
        try (AccessExternalClientV2 client = this.accessExternalClientV2Factory.getClient();){
            RequestResponse requestResponse = client.exportDIP(context, dipRequest);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> transferSIP(TransferRequest transferRequest, VitamContext context) throws VitamClientException {
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            RequestResponse requestResponse = client.transfer(context, transferRequest);
            return requestResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadExports(AsyncResponse asyncResponse, String exportId, VitamContext context, boolean isTransfer) throws UnsupportedEncodingException, VitamClientException {
        Response response = null;
        try (AccessExternalClient client = this.accessExternalClientFactory.getClient();){
            String prefix;
            if (isTransfer) {
                response = client.getTransferById(context, exportId);
                prefix = "TRANSFER";
            } else {
                response = client.getDIPById(context, exportId);
                prefix = "DIP";
            }
            AsyncInputStreamHelper helper = new AsyncInputStreamHelper(asyncResponse, response);
            Response.ResponseBuilder responseBuilder = Response.status((int)response.getStatus()).header("Content-Disposition", (Object)("filename=\"" + URLDecoder.decode(prefix + "-" + exportId + ".zip", "UTF-8") + "\"")).type(response.getMediaType());
            helper.writeResponse(responseBuilder);
        }
        finally {
            if (response != null && response.getStatus() != Response.Status.OK.getStatusCode()) {
                try {
                    Object object;
                    if (response.hasEntity() && (object = response.getEntity()) instanceof InputStream) {
                        StreamUtils.closeSilently((InputStream)((InputStream)object));
                    }
                }
                catch (IllegalStateException | ProcessingException e) {
                    LOGGER.debug(e);
                }
                finally {
                    response.close();
                }
            }
        }
        return true;
    }

    public VitamContext getVitamContext(HttpServletRequest request) {
        return this.getVitamContext(this.getTenantId(request), this.getContractId(request), request);
    }

    public VitamContext getVitamContext(Integer tenantId, String contractId, String personalCert) {
        return new VitamContext(tenantId).setAccessContract(contractId).setApplicationSessionId(this.getAppSessionId()).setPersonalCertificate(personalCert);
    }

    public VitamContext getVitamContext(Integer tenantId, String contractId, HttpServletRequest request) {
        String personalCert = this.getPersonalCertificate(request);
        if (personalCert != null) {
            return new VitamContext(tenantId).setAccessContract(contractId).setApplicationSessionId(this.getAppSessionId()).setPersonalCertificate(personalCert);
        }
        return new VitamContext(tenantId).setAccessContract(contractId).setApplicationSessionId(this.getAppSessionId());
    }

    public String getPersonalCertificate(HttpServletRequest request) {
        return (String)request.getAttribute("Personae");
    }

    public String getContractId(HttpServletRequest request) {
        return request.getHeader("X-Access-Contract-Id");
    }

    public Integer getTenantId(HttpServletRequest request) {
        Integer tenantId = 0;
        String tenantIdHeader = request.getHeader("X-Tenant-Id");
        if (tenantIdHeader != null) {
            try {
                tenantId = Integer.parseInt(tenantIdHeader);
            }
            catch (NumberFormatException e) {
                LOGGER.error("No tenant defined, using default tenant");
            }
        }
        return tenantId;
    }

    public String getAppSessionId() {
        return "MyApplicationId-ChangeIt";
    }
}

