/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.ihmdemo.core.UiConstants;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public final class JsonTransformer {
    private static final String MISSING_ID_ERROR_MSG = "Encountered Missing ID field in the given parents list.";
    private static final String MISSING_UP_ERROR_MSG = "Encountered Missing _up field in the given parents list.";
    private static final String INVALID_UP_FIELD_ERROR_MSG = "Encountered invalid _up field in the given parents list.";
    private static final String MISSING_UNIT_ID_ERROR_MSG = "The unit details is missing.";
    private static final String EVENT_DATE_TIME_FIELD = "evDateTime";
    private static final String EVENTS_FIELD = "events";
    private static final String START_EVENT_DATETIME_HEADER = "startEventDateTime";
    private static final String END_EVENT_DATETIME_HEADER = "endEventDateTime";
    private static final String EXECUTION_TIME_HEADER = "executionTime (ms)";
    private static final char SEMI_COLON_SEPARATOR = ';';
    private static final char RECORD_SEPARATOR = '\n';
    private static final String UNEXPECTED_EXCEPTION_DURING_CSV_FILE_GENERATION = "An unexpected error occurred during CSV file generation process";

    private JsonTransformer() {
    }

    public static JsonNode transformResultObjects(JsonNode searchResult) {
        ParametersChecker.checkParameter((String)"Result cannot be empty", (Object[])new Object[]{searchResult});
        ObjectNode resultNode = JsonHandler.createObjectNode();
        long nbObjects = 0L;
        JsonNode result = searchResult.get("$results").get(0);
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        if (result != null) {
            JsonNode qualifiers = result.get("#qualifiers");
            List versions = qualifiers.findValues("versions");
            HashMap<String, Integer> usages = new HashMap<String, Integer>();
            for (JsonNode version : versions) {
                for (JsonNode object : version) {
                    arrayNode.add((JsonNode)JsonTransformer.getDataObject(usages, object));
                    ++nbObjects;
                }
            }
        }
        resultNode.put("nbObjects", nbObjects);
        resultNode.set("versions", (JsonNode)arrayNode);
        return resultNode;
    }

    private static ObjectNode getDataObject(Map<String, Integer> usages, JsonNode object) {
        ObjectNode objectNode = JsonHandler.createObjectNode();
        objectNode.put("#id", object.get(UiConstants.ID.getResultCriteria()).asText());
        String usage = object.get("DataObjectVersion").asText();
        JsonNode finalInfo = object.get("FileInfo");
        if (usages.containsKey(usage)) {
            Integer rank = usages.get(usage) + 1;
            objectNode.put("Rank", rank);
        } else {
            usages.put(usage, 0);
            objectNode.put("Rank", 0);
        }
        objectNode.put("DataObjectVersion", usage);
        if (object.get("Size") != null) {
            objectNode.put("Size", object.get("Size").asText());
        }
        if (finalInfo != null && finalInfo.get("LastModified") != null) {
            objectNode.put("LastModified", finalInfo.get("LastModified").asText());
        }
        if (object.get("FormatIdentification") != null && object.get("FormatIdentification").get("FormatLitteral") != null) {
            objectNode.put("FormatLitteral", object.get("FormatIdentification").get("FormatLitteral").asText());
        }
        if (finalInfo != null && finalInfo.get("Filename") != null) {
            objectNode.put("FileName", finalInfo.get("Filename").asText());
        }
        objectNode.set("metadatas", object);
        return objectNode;
    }

    public static ObjectNode buildAllParentsRef(String unitId, JsonNode allParents) throws VitamException {
        ParametersChecker.checkParameter((String)"Result cannot be empty", (Object[])new Object[]{allParents});
        boolean hasUnitId = false;
        ObjectNode allParentsRef = JsonHandler.createObjectNode();
        for (JsonNode currentParentNode : allParents) {
            if (!currentParentNode.has(UiConstants.ID.getResultCriteria())) {
                throw new VitamException(MISSING_ID_ERROR_MSG);
            }
            if (!currentParentNode.has(UiConstants.UNITUPS.getResultCriteria())) {
                throw new VitamException(MISSING_UP_ERROR_MSG);
            }
            if (!currentParentNode.get(UiConstants.UNITUPS.getResultCriteria()).isArray()) {
                throw new VitamException(INVALID_UP_FIELD_ERROR_MSG);
            }
            String currentParentId = currentParentNode.get(UiConstants.ID.getResultCriteria()).asText();
            allParentsRef.set(currentParentId, currentParentNode);
            if (!unitId.equalsIgnoreCase(currentParentId)) continue;
            hasUnitId = true;
        }
        if (!hasUnitId) {
            throw new VitamException(MISSING_UNIT_ID_ERROR_MSG);
        }
        return allParentsRef;
    }

    public static ByteArrayOutputStream buildLogbookStatCsvFile(JsonNode logbookOperation) throws VitamException, IOException {
        ByteArrayOutputStream csvOutputStream = new ByteArrayOutputStream();
        try (BufferedWriter csvWriter = new BufferedWriter(new OutputStreamWriter(csvOutputStream));){
            String startOperationTimeStr = logbookOperation.get(EVENT_DATE_TIME_FIELD).asText();
            List events = IteratorUtils.toList((Iterator)logbookOperation.get(EVENTS_FIELD).iterator());
            JsonNode lastEvent = (JsonNode)events.get(events.size() - 1);
            String endOperationTimeStr = lastEvent.get(EVENT_DATE_TIME_FIELD).asText();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)csvWriter, CSVFormat.newFormat((char)';').withRecordSeparator('\n'));
            List header = IteratorUtils.toList((Iterator)lastEvent.fieldNames());
            header.add(START_EVENT_DATETIME_HEADER);
            header.add(END_EVENT_DATETIME_HEADER);
            header.add(EXECUTION_TIME_HEADER);
            csvPrinter.printRecord((Iterable)header);
            for (int i = 0; i < events.size() - 1; i += 2) {
                JsonNode startEvent = (JsonNode)events.get(i);
                JsonNode endEvent = (JsonNode)events.get(i + 1);
                List eventReportDetails = IteratorUtils.toList((Iterator)endEvent.elements());
                String startEventDateTimeStr = startEvent.get(EVENT_DATE_TIME_FIELD).asText();
                String endEventDateTimeStr = endEvent.get(EVENT_DATE_TIME_FIELD).asText();
                eventReportDetails.add(startEventDateTimeStr);
                eventReportDetails.add(endEventDateTimeStr);
                eventReportDetails.add(JsonTransformer.calculateExecutionTime(startEventDateTimeStr, endEventDateTimeStr).toString());
                csvPrinter.printRecord((Iterable)eventReportDetails);
            }
            List lastEventDetails = IteratorUtils.toList((Iterator)lastEvent.elements());
            lastEventDetails.add(startOperationTimeStr);
            lastEventDetails.add(endOperationTimeStr);
            lastEventDetails.add(JsonTransformer.calculateExecutionTime(startOperationTimeStr, endOperationTimeStr).toString());
            csvPrinter.printRecord((Iterable)lastEventDetails);
            csvPrinter.flush();
            csvPrinter.close();
        }
        catch (Exception e) {
            csvOutputStream.close();
            throw new VitamException(UNEXPECTED_EXCEPTION_DURING_CSV_FILE_GENERATION);
        }
        return csvOutputStream;
    }

    private static Long calculateExecutionTime(String startDateTimeStr, String endDateTimeStr) throws ParseException {
        Date startDateTime = LocalDateUtil.getDate((String)startDateTimeStr);
        Date endDateTime = LocalDateUtil.getDate((String)endDateTimeStr);
        return endDateTime.getTime() - startDateTime.getTime();
    }
}

