/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.database.facet.model.FacetOrder;
import fr.gouv.vitam.common.model.FacetDateRangeItem;
import fr.gouv.vitam.common.model.FacetFiltersItem;
import fr.gouv.vitam.common.model.FacetType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FacetItem {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="facetType")
    private FacetType facetType;
    @JsonProperty(value="field")
    private String field;
    @JsonProperty(value="subobject")
    private String subobject;
    @JsonProperty(value="size")
    private Integer size;
    @JsonProperty(value="order")
    private FacetOrder order;
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="ranges")
    private List<FacetDateRangeItem> ranges;
    @JsonProperty(value="filters")
    private List<FacetFiltersItem> filters;
    private static final Map<String, String> nestedFields = Stream.of({"#qualifiers.versions.FormatIdentification.FormatLitteral", "#qualifiers.versions"}, {"#qualifiers.versions.DataObjectVersion", "#qualifiers.versions"}).collect(Collectors.collectingAndThen(Collectors.toMap(data -> data[0], data -> data[1]), Collections::unmodifiableMap));

    public FacetItem() {
    }

    public FacetItem(String name, FacetType facetType, String field, Integer size, FacetOrder order, String format, List<FacetDateRangeItem> ranges, List<FacetFiltersItem> filters, Optional<String> subobject) {
        this.name = name;
        this.facetType = facetType;
        this.field = field;
        this.size = size;
        this.order = order;
        this.format = format;
        this.ranges = ranges;
        this.filters = filters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
        if (nestedFields.containsKey(field)) {
            this.subobject = nestedFields.get(field);
        }
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public List<FacetDateRangeItem> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<FacetDateRangeItem> ranges) {
        this.ranges = ranges;
    }

    public List<FacetFiltersItem> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FacetFiltersItem> filters) {
        this.filters = filters;
    }

    public FacetType getFacetType() {
        return this.facetType;
    }

    public void setFacetType(FacetType facetType) {
        this.facetType = facetType;
    }

    public FacetOrder getOrder() {
        return this.order;
    }

    public void setOrder(FacetOrder order) {
        this.order = order;
    }

    public String getSubobject() {
        return this.subobject;
    }
}

