/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.driver.fake;

import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.client.TestVitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.client.VitamRestEasyConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.collection.CloseableIteratorUtils;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.storage.driver.AbstractConnection;
import fr.gouv.vitam.storage.driver.AbstractDriver;
import fr.gouv.vitam.storage.driver.Connection;
import fr.gouv.vitam.storage.driver.exception.StorageDriverConflictException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.storage.driver.model.StorageAccessRequestCreationRequest;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResultEntry;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutRequest;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.driver.model.StorageCapacityResult;
import fr.gouv.vitam.storage.driver.model.StorageCheckObjectAvailabilityRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetBulkMetadataRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetMetadataRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetResult;
import fr.gouv.vitam.storage.driver.model.StorageListRequest;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageObjectRequest;
import fr.gouv.vitam.storage.driver.model.StorageOfferLogRequest;
import fr.gouv.vitam.storage.driver.model.StoragePutRequest;
import fr.gouv.vitam.storage.driver.model.StoragePutResult;
import fr.gouv.vitam.storage.driver.model.StorageRemoveRequest;
import fr.gouv.vitam.storage.driver.model.StorageRemoveResult;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.IOUtils;

public class FakeDriverImpl
extends AbstractDriver {
    private final Map<String, FakeConnectionImpl> fakeConnection = new ConcurrentHashMap<String, FakeConnectionImpl>();

    protected VitamClientFactoryInterface<FakeConnectionImpl> addInternalOfferAsFactory(final StorageOffer offer, Properties parameters) {
        return new VitamClientFactoryInterface<FakeConnectionImpl>(){
            private final StorageOffer offerf;
            {
                this.offerf = offer;
            }

            public Client getHttpClient() {
                return null;
            }

            public Client getHttpClient(boolean useChunkedMode) {
                return null;
            }

            public FakeConnectionImpl getClient() {
                return FakeDriverImpl.this.fakeConnection.computeIfAbsent(offer.getId(), x$0 -> new FakeConnectionImpl((String)x$0));
            }

            public String getResourcePath() {
                return null;
            }

            public String getServiceUrl() {
                return this.offerf.getBaseUrl();
            }

            public Map<VitamRestEasyConfiguration, Object> getDefaultConfigCient() {
                return null;
            }

            public Map<VitamRestEasyConfiguration, Object> getDefaultConfigCient(boolean chunkedMode) {
                return null;
            }

            public ClientConfiguration getClientConfiguration() {
                return null;
            }

            public VitamClientFactoryInterface.VitamClientType getVitamClientType() {
                return null;
            }

            public VitamClientFactoryInterface<?> setVitamClientType(VitamClientFactoryInterface.VitamClientType vitamClientType) {
                return null;
            }

            public void changeResourcePath(String resourcePath) {
            }

            public void changeServerPort(int port) {
            }

            public void shutdown() {
            }

            public void resume(Client client, boolean chunk) {
            }
        };
    }

    @Nonnull
    public Connection connect(String offerId) throws StorageDriverException {
        if (offerId.contains("fail")) {
            throw new StorageDriverException(this.getName(), "Intentionaly thrown", false);
        }
        return (Connection)this.fakeConnection.computeIfAbsent(offerId, x$0 -> new FakeConnectionImpl((String)x$0));
    }

    public boolean isStorageOfferAvailable(String offerId) throws StorageDriverException {
        if (offerId.contains("fail")) {
            throw new StorageDriverException(this.getName(), "Intentionaly thrown", false);
        }
        return true;
    }

    public String getName() {
        return "Fake driver";
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public void clear() {
        this.fakeConnection.clear();
    }

    public class FakeConnectionImpl
    extends AbstractConnection {
        private final String offerId;
        private ThrowableFunction<StorageObjectRequest, StorageGetResult> getObjectFunction;

        FakeConnectionImpl(String offerId) {
            super("FakeDriverName", (VitamClientFactoryInterface)new TestVitamClientFactory(1324, "/chemin/"));
            this.offerId = offerId;
            this.getObjectFunction = objectRequest -> {
                if (this.offerId.equals("myTapeOffer1") && objectRequest.getGuid().equals("MyUnavailableFromAsyncOfferObjectId")) {
                    throw new StorageDriverUnavailableDataFromAsyncOfferException("any", "msg");
                }
                MultivaluedHashMap headers = new MultivaluedHashMap();
                headers.add((Object)VitamHttpHeader.X_CONTENT_LENGTH.getName(), (Object)"4");
                return new StorageGetResult(objectRequest.getTenantId(), objectRequest.getType(), objectRequest.getGuid(), (Response)new AbstractMockClient.FakeInboundResponse(Response.Status.OK, (Object)new ByteArrayInputStream("test".getBytes()), MediaType.APPLICATION_OCTET_STREAM_TYPE, headers));
            };
        }

        public String getOfferId() {
            return this.offerId;
        }

        public void setGetObjectFunction(ThrowableFunction<StorageObjectRequest, StorageGetResult> getObjectFunction) {
            this.getObjectFunction = getObjectFunction;
        }

        public StorageCapacityResult getStorageCapacity(Integer tenantId) throws StorageDriverException {
            Integer fakeTenant = -1;
            if (fakeTenant.equals(tenantId)) {
                throw new StorageDriverException("driverInfo", "ExceptionTest", false);
            }
            return new StorageCapacityResult(tenantId, 1000000L);
        }

        public StorageGetResult getObject(StorageObjectRequest objectRequest) throws StorageDriverException {
            return this.getObjectFunction.apply(objectRequest);
        }

        public String createAccessRequest(StorageAccessRequestCreationRequest request) {
            if (this.offerId.equals("myTapeOffer1")) {
                return "myAccessRequestId1";
            }
            if (this.offerId.equals("myTapeOffer2")) {
                return "myAccessRequestId2";
            }
            throw new IllegalStateException("createAccessRequest should not be invoked with sync offer '" + this.offerId + "'");
        }

        public Map<String, AccessRequestStatus> checkAccessRequestStatuses(List<String> accessRequestIds, int tenant, boolean adminCrossTenantAccessRequestAllowed) {
            if (this.offerId.equals("myTapeOffer1")) {
                if (!adminCrossTenantAccessRequestAllowed) {
                    throw new IllegalStateException("expected adminCrossTenantAccessRequestAllowed flag to be set");
                }
                return accessRequestIds.stream().collect(Collectors.toMap(accessRequestId -> accessRequestId, accessRequestId -> AccessRequestStatus.READY));
            }
            if (this.offerId.equals("myTapeOffer2")) {
                if (adminCrossTenantAccessRequestAllowed) {
                    throw new IllegalStateException("expected adminCrossTenantAccessRequestAllowed flag to not be set");
                }
                return accessRequestIds.stream().collect(Collectors.toMap(accessRequestId -> accessRequestId, accessRequestId -> AccessRequestStatus.NOT_READY));
            }
            throw new IllegalStateException("checkAccessRequestStatuses should not be invoked with sync offer '" + this.offerId + "'");
        }

        public void removeAccessRequest(String accessRequestId, int tenant, boolean adminCrossTenantAccessRequestAllowed) {
            if (!adminCrossTenantAccessRequestAllowed) {
                throw new IllegalStateException("expected adminCrossTenantAccessRequestAllowed flag to be set");
            }
            if (this.offerId.equals("myTapeOffer1") || this.offerId.equals("myTapeOffer2")) {
                return;
            }
            throw new IllegalStateException("removeAccessRequest should not be invoked with sync offer '" + this.offerId + "'");
        }

        public boolean checkObjectAvailability(StorageCheckObjectAvailabilityRequest request) {
            if (this.offerId.equals("myTapeOffer1")) {
                return true;
            }
            if (this.offerId.equals("myTapeOffer2")) {
                return false;
            }
            throw new IllegalStateException("checkObjectAvailability should not be invoked with sync offer '" + this.offerId + "'");
        }

        public StoragePutResult putObject(StoragePutRequest objectRequest) throws StorageDriverException {
            if ("digest_bad_test".equals(objectRequest.getGuid())) {
                return new StoragePutResult(objectRequest.getTenantId(), objectRequest.getType(), objectRequest.getGuid(), objectRequest.getGuid(), "different_digest_hash", 0L);
            }
            if (("fail-offer-" + this.offerId).equals(objectRequest.getGuid())) {
                throw new StorageDriverException(FakeDriverImpl.this.getName(), "Fake offer " + this.offerId + " failed", false);
            }
            if ("conflict".equals(objectRequest.getGuid())) {
                throw new StorageDriverConflictException(FakeDriverImpl.this.getName(), "conflict");
            }
            if ("retry_test".equals(objectRequest.getGuid())) {
                throw new StorageDriverException(FakeDriverImpl.this.getName(), "retry_test", false);
            }
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)objectRequest.getDataStream());
                MessageDigest messageDigest = MessageDigest.getInstance(objectRequest.getDigestAlgorithm());
                return new StoragePutResult(objectRequest.getTenantId(), objectRequest.getType(), objectRequest.getGuid(), objectRequest.getGuid(), BaseXx.getBase16((byte[])messageDigest.digest(bytes)), (long)bytes.length);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new StorageDriverException(FakeDriverImpl.this.getName(), "Digest or Storage Put in error", false, (Throwable)e);
            }
        }

        public StorageBulkPutResult bulkPutObjects(StorageBulkPutRequest request) {
            throw new IllegalStateException("Fake driver not implemented");
        }

        public StorageRemoveResult removeObject(StorageRemoveRequest objectRequest) {
            return new StorageRemoveResult(objectRequest.getTenantId(), objectRequest.getType(), objectRequest.getGuid(), true);
        }

        public boolean objectExistsInOffer(StorageObjectRequest request) {
            return "already_in_offer".equals(request.getGuid());
        }

        public StorageMetadataResult getMetadatas(StorageGetMetadataRequest request) {
            return new StorageMetadataResult((MetadatasObject)new StorageMetadataResult(request.getGuid(), request.getType(), "digest", 1234L, "now", "now"));
        }

        public StorageBulkMetadataResult getBulkMetadata(StorageGetBulkMetadataRequest request) {
            return new StorageBulkMetadataResult(request.getGuids().stream().map(objectId -> new StorageBulkMetadataResultEntry(objectId, "digest-" + objectId, Long.valueOf(50L))).collect(Collectors.toList()));
        }

        public CloseableIterator<ObjectEntry> listObjects(StorageListRequest request) {
            return CloseableIteratorUtils.toCloseableIterator((Iterator)IteratorUtils.singletonListIterator((Object)new ObjectEntry("objectId", 100L)));
        }

        public RequestResponse<OfferLog> getOfferLogs(StorageOfferLogRequest storageOfferLogRequest) {
            OfferLog offerLog = new OfferLog();
            offerLog.setContainer(storageOfferLogRequest.getType() + "_" + storageOfferLogRequest.getTenantId());
            offerLog.setFileName("fileName_" + (storageOfferLogRequest.getOffset() + 1L));
            offerLog.setSequence(storageOfferLogRequest.getOffset() + 1L);
            offerLog.setTime(LocalDateTime.of(2017, 12, 13, 12, 0, 0, 0));
            RequestResponseOK requestResponseOK = new RequestResponseOK();
            requestResponseOK.addResult((Object)offerLog);
            return requestResponseOK;
        }

        public Response launchOfferLogCompaction(VitamContext vitamContext) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws StorageDriverException;
    }
}

