/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.traceability;

import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.TimeStampException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.merkletree.MerkleTree;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.common.timestamp.TimestampGenerator;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.model.TraceabilityFile;
import fr.gouv.vitam.logbook.common.model.TraceabilityStatistics;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.common.traceability.TimeStampService;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.compress.archivers.ArchiveException;

public class TraceabilityService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TraceabilityService.class);
    private final TimestampGenerator timestampGenerator;
    private final Integer tenantId;
    private final LogbookTraceabilityHelper helper;
    private final File tmpFolder;
    private final DateTimeFormatter formatter;
    private static final String SECURISATION_VERSION = "V1";
    private File zipFile = null;

    public TraceabilityService(TimestampGenerator timestampGenerator, LogbookTraceabilityHelper traceabilityHelper, Integer tenantId, File tmpFolder) {
        this.timestampGenerator = timestampGenerator;
        this.tenantId = tenantId;
        this.helper = traceabilityHelper;
        this.tmpFolder = tmpFolder;
        this.formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        tmpFolder.mkdir();
    }

    public void secureData(String strategyId) throws TraceabilityException {
        TraceabilityEvent event;
        String fileName;
        block10: {
            this.helper.startTraceability();
            fileName = this.createZipFile(this.tenantId, LocalDateUtil.parseMongoFormattedDate((String)this.helper.getTraceabilityEndDate()));
            try (TraceabilityFile traceabilityFile = new TraceabilityFile(this.zipFile);){
                MerkleTreeAlgo merkleAlgo = new MerkleTreeAlgo(VitamConfiguration.getDefaultDigestType());
                this.helper.saveDataInZip(merkleAlgo, traceabilityFile);
                MerkleTree merkleTree = merkleAlgo.generateMerkle();
                if (merkleTree != null) {
                    traceabilityFile.storeMerkleTree(merkleTree);
                    byte[] merkleRootHash = merkleTree.getRoot();
                    String rootHash = BaseXx.getBase64((byte[])merkleRootHash);
                    byte[] timestampToken = this.computeAndStoreTimestampToken(traceabilityFile, merkleRootHash);
                    long numberOfLine = this.helper.getDataSize();
                    String startDate = this.helper.getTraceabilityStartDate();
                    String endDate = this.helper.getTraceabilityEndDate();
                    traceabilityFile.storeAdditionalInformation(numberOfLine, startDate, endDate);
                    String previousDate = this.helper.getPreviousStartDate();
                    String previousMonthDate = this.helper.getPreviousMonthStartDate();
                    String previousYearDate = this.helper.getPreviousYearStartDate();
                    long size = this.zipFile.length();
                    boolean maxEntriesReached = this.helper.getMaxEntriesReached();
                    TraceabilityStatistics traceabilityStatistics = this.helper.getTraceabilityStatistics();
                    event = new TraceabilityEvent(this.helper.getTraceabilityType(), startDate, endDate, rootHash, timestampToken, previousDate, previousMonthDate, previousYearDate, numberOfLine, fileName, size, VitamConfiguration.getDefaultDigestType(), maxEntriesReached, SECURISATION_VERSION, traceabilityStatistics);
                    break block10;
                }
                LOGGER.warn("No entries to be processed");
                this.helper.saveEmpty(this.tenantId);
                if (!this.zipFile.delete()) {
                    LOGGER.error("Unable to delete zipFile");
                }
                return;
            }
            catch (InvalidParseOperationException | IOException | ArchiveException e) {
                this.helper.createLogbookOperationEvent(this.tenantId, this.helper.getStepName(), StatusCode.FATAL, null);
                if (!this.zipFile.delete()) {
                    LOGGER.error("Can't delete zipFile");
                }
                throw new TraceabilityException(e);
            }
        }
        this.helper.storeAndDeleteZip(this.tenantId, strategyId, this.zipFile, fileName, event);
        this.helper.createLogbookOperationEvent(this.tenantId, this.helper.getStepName(), StatusCode.OK, event);
    }

    private String createZipFile(Integer tenantId, LocalDateTime date) {
        String fileName = String.format("%d_%s_%s.zip", tenantId, this.helper.getZipName(), date.format(this.formatter));
        this.zipFile = new File(this.tmpFolder, fileName);
        return fileName;
    }

    private byte[] computeAndStoreTimestampToken(TraceabilityFile file, byte[] merkleRootHash) throws IOException, TraceabilityException, InvalidParseOperationException {
        String rootHash = BaseXx.getBase64((byte[])merkleRootHash);
        byte[] timestampToken1 = this.helper.getPreviousTimestampToken();
        byte[] timestampToken2 = this.helper.getPreviousMonthTimestampToken();
        byte[] timestampToken3 = this.helper.getPreviousYearTimestampToken();
        String timestampToken1Base64 = timestampToken1 == null ? null : BaseXx.getBase64((byte[])timestampToken1);
        String timestampToken2Base64 = timestampToken2 == null ? null : BaseXx.getBase64((byte[])timestampToken2);
        String timestampToken3Base64 = timestampToken3 == null ? null : BaseXx.getBase64((byte[])timestampToken3);
        byte[] timestampToken = this.generateTimeStampToken(merkleRootHash, timestampToken1, timestampToken2, timestampToken3);
        file.storeTimeStampToken(timestampToken);
        file.storeComputedInformation(rootHash, timestampToken1Base64, timestampToken2Base64, timestampToken3Base64);
        return timestampToken;
    }

    private byte[] generateTimeStampToken(byte[] rootHash, byte[] hash1, byte[] hash2, byte[] hash3) throws TraceabilityException {
        try {
            TimeStampService timeStampService = new TimeStampService();
            byte[] hashDigest = timeStampService.getDigestFrom(rootHash, hash1, hash2, hash3);
            DigestType digestType = timeStampService.getDigestType();
            byte[] timeStampToken = this.timestampGenerator.generateToken(hashDigest, digestType, null);
            this.helper.createLogbookOperationEvent(this.tenantId, this.helper.getTimestampStepName(), StatusCode.OK, null);
            return timeStampToken;
        }
        catch (TimeStampException e) {
            LOGGER.error("unable to generate timestamp", (Throwable)e);
            this.helper.createLogbookOperationEvent(this.tenantId, this.helper.getTimestampStepName(), StatusCode.FATAL, null);
            throw new TraceabilityException(e);
        }
    }
}

