/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.traceability;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.encoders.Base64;

public class TimeStampService {
    private final DigestType digestType;

    public TimeStampService() {
        this(VitamConfiguration.getDefaultTimestampDigestType());
    }

    @VisibleForTesting
    public TimeStampService(DigestType digestType) {
        this.digestType = digestType;
    }

    public byte[] getDigestFrom(byte[] ... toCompute) {
        Digest digest = new Digest(this.digestType);
        for (byte[] bytes : toCompute) {
            if (bytes == null) continue;
            digest.update(bytes);
        }
        return digest.digest();
    }

    public TimeStampToken getTimeStampFrom(String timeStampAsString) throws IOException, TSPException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.decode((byte[])timeStampAsString.getBytes(StandardCharsets.US_ASCII)));){
            TimeStampToken timeStampToken;
            try (ASN1InputStream timeStampAsn1Stream = new ASN1InputStream((InputStream)is);){
                ASN1Primitive timeStampAsn1Primitive = timeStampAsn1Stream.readObject();
                if (timeStampAsn1Primitive == null) {
                    throw new IOException("Cannot get ASN1Primitive.");
                }
                TimeStampToken timeStampToken2 = new TimeStampResponse(timeStampAsn1Primitive.getEncoded()).getTimeStampToken();
                if (timeStampToken2.getTimeStampInfo().getNonce() != null) {
                    throw new IOException("Timestamp token nonce cannot be filled.");
                }
                timeStampToken = timeStampToken2;
            }
            return timeStampToken;
        }
    }

    public byte[] getDigestAsBytes(String property) {
        return Objects.isNull(property) || property.equals("null") ? null : BaseXx.getFromBase64((String)property);
    }

    public DigestType getDigestType() {
        return this.digestType;
    }
}

