/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.parameters;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.common.client.ErrorMessage;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import java.text.ParseException;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LogbookOperationsClientHelper {
    private static final ServerIdentity SERVER_IDENTITY = ServerIdentity.getInstance();
    private final Map<String, Queue<LogbookOperationParameters>> delegatedCreations = new ConcurrentHashMap<String, Queue<LogbookOperationParameters>>();
    private final Map<String, Queue<LogbookOperationParameters>> delegatedUpdates = new ConcurrentHashMap<String, Queue<LogbookOperationParameters>>();
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookOperationsClientHelper.class);

    public static String checkLogbookParameters(LogbookOperationParameters parameters) {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        if (!LogbookTypeProcess.EXTERNAL_LOGBOOK.equals((Object)parameters.getTypeProcess()) || parameters.getParameterValue(LogbookParameterName.eventDateTime) == null) {
            parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        } else {
            try {
                LocalDateUtil.getDate((String)parameters.getParameterValue(LogbookParameterName.eventDateTime));
                LOGGER.warn("External date : " + parameters.getParameterValue(LogbookParameterName.eventDateTime));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Wrong date format : " + parameters.getParameterValue(LogbookParameterName.eventDateTime));
            }
        }
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        return parameters.getParameterValue(LogbookParameterName.eventIdentifierProcess);
    }

    public static final LogbookOperationParameters copy(LogbookOperationParameters source) {
        LogbookOperationParameters copy = LogbookParameterHelper.newLogbookOperationParameters();
        copy.getMapParameters().putAll(source.getMapParameters());
        return copy;
    }

    public void createDelegate(LogbookOperationParameters parameters) throws LogbookClientAlreadyExistsException {
        String key = LogbookOperationsClientHelper.checkLogbookParameters(parameters);
        if (this.delegatedCreations.containsKey(key)) {
            throw new LogbookClientAlreadyExistsException(ErrorMessage.LOGBOOK_ALREADY_EXIST.getMessage());
        }
        ConcurrentLinkedQueue<LogbookOperationParameters> queue = new ConcurrentLinkedQueue<LogbookOperationParameters>();
        queue.add(LogbookOperationsClientHelper.copy(parameters));
        this.delegatedCreations.put(key, queue);
    }

    public void updateDelegate(LogbookOperationParameters parameters) throws LogbookClientNotFoundException {
        String key = LogbookOperationsClientHelper.checkLogbookParameters(parameters);
        Queue<LogbookOperationParameters> queue = this.delegatedCreations.get(key);
        if (queue == null && (queue = this.delegatedUpdates.get(key)) == null) {
            queue = new ConcurrentLinkedQueue<LogbookOperationParameters>();
            this.delegatedUpdates.put(key, queue);
        }
        queue.add(LogbookOperationsClientHelper.copy(parameters));
    }

    public Queue<LogbookOperationParameters> removeCreateDelegate(String key) {
        return this.delegatedCreations.remove(key);
    }

    public Queue<LogbookOperationParameters> removeUpdateDelegate(String key) {
        return this.delegatedUpdates.remove(key);
    }

    public void clear() {
        this.delegatedCreations.clear();
        this.delegatedUpdates.clear();
    }
}

