/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.parameters;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.logbook.common.client.ErrorMessage;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@Deprecated
public class LogbookLifeCyclesClientHelper {
    private static final ServerIdentity SERVER_IDENTITY = ServerIdentity.getInstance();
    private final Map<String, Queue<LogbookLifeCycleParameters>> delegatedCreations = new ConcurrentHashMap<String, Queue<LogbookLifeCycleParameters>>();
    private final Map<String, Queue<LogbookLifeCycleParameters>> delegatedUpdates = new ConcurrentHashMap<String, Queue<LogbookLifeCycleParameters>>();

    public static String checkLogbookParameters(LogbookLifeCycleParameters parameters) {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        return parameters.getParameterValue(LogbookParameterName.objectIdentifier);
    }

    public static LogbookLifeCycleParameters copy(LogbookLifeCycleParameters source) {
        LogbookLifeCycleParameters copy = source instanceof LogbookLifeCycleObjectGroupParameters ? LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters() : LogbookParameterHelper.newLogbookLifeCycleUnitParameters();
        copy.getMapParameters().putAll(source.getMapParameters());
        return copy;
    }

    public void createDelegate(LogbookLifeCycleParameters parameters) throws LogbookClientAlreadyExistsException {
        String key = LogbookLifeCyclesClientHelper.checkLogbookParameters(parameters);
        if (this.delegatedCreations.containsKey(key)) {
            throw new LogbookClientAlreadyExistsException(ErrorMessage.LOGBOOK_ALREADY_EXIST.getMessage());
        }
        ConcurrentLinkedQueue<LogbookLifeCycleParameters> queue = new ConcurrentLinkedQueue<LogbookLifeCycleParameters>();
        queue.add(LogbookLifeCyclesClientHelper.copy(parameters));
        this.delegatedCreations.put(key, queue);
    }

    public void updateDelegate(LogbookLifeCycleParameters parameters) throws LogbookClientNotFoundException {
        String key = LogbookLifeCyclesClientHelper.checkLogbookParameters(parameters);
        Queue<LogbookLifeCycleParameters> queue = this.delegatedCreations.get(key);
        if (queue == null && (queue = this.delegatedUpdates.get(key)) == null) {
            queue = new ConcurrentLinkedQueue<LogbookLifeCycleParameters>();
            this.delegatedUpdates.put(key, queue);
        }
        queue.add(LogbookLifeCyclesClientHelper.copy(parameters));
    }

    public Queue<? extends LogbookLifeCycleParameters> removeCreateDelegate(String key) {
        return this.delegatedCreations.remove(key);
    }

    public Queue<? extends LogbookLifeCycleParameters> removeUpdateDelegate(String key) {
        return this.delegatedUpdates.remove(key);
    }

    public boolean containsUpdate(String key) {
        return this.delegatedUpdates.containsKey(key) && this.delegatedUpdates.get(key).size() > 0;
    }

    public boolean containsCreate(String key) {
        return this.delegatedCreations.containsKey(key) && this.delegatedCreations.get(key).size() > 0;
    }

    public Set<Map.Entry<String, Queue<LogbookLifeCycleParameters>>> getAllCreations() {
        return this.delegatedCreations.entrySet();
    }

    public Set<Map.Entry<String, Queue<LogbookLifeCycleParameters>>> getAllUpdates() {
        return this.delegatedUpdates.entrySet();
    }

    public void clear() {
        this.delegatedCreations.clear();
        this.delegatedUpdates.clear();
    }

    public void updateDelegateWithKey(String key, LogbookLifeCycleParameters parameters) {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        Queue<LogbookLifeCycleParameters> queue = this.delegatedCreations.get(key);
        if (queue == null && (queue = this.delegatedUpdates.get(key)) == null) {
            queue = new ConcurrentLinkedQueue<LogbookLifeCycleParameters>();
            this.delegatedUpdates.put(key, queue);
        }
        queue.add(LogbookLifeCyclesClientHelper.copy(parameters));
    }
}

