/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import fr.gouv.vitam.batch.report.model.entry.UpdateUnitMetadataReportEntry;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateUnitReportRepository
extends ReportCommonRepository {
    private static final String UPDATE_UNIT_REPORT = "UpdateUnitReport";
    private final MongoCollection<Document> collection;
    private static final Bson PROJECTION = Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("resultKey", (Object)"$resultKey"), new Document("processId", (Object)"$processId"), new Document("_tenant", (Object)"$_tenant"), new Document("status", (Object)"$status"), new Document("message", (Object)"$message"), new Document("outcome", (Object)"$outcome"), new Document("detailType", (Object)"$detailType"), new Document("id", (Object)"$id")}));

    @VisibleForTesting
    public UpdateUnitReportRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.collection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public UpdateUnitReportRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, UPDATE_UNIT_REPORT);
    }

    private static WriteModel<Document> modelToWriteDocument(UpdateUnitMetadataReportEntry model) {
        try {
            return new UpdateOneModel(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)model.getProcessId()), Filters.eq((String)"_tenant", (Object)model.getTenantId()), Filters.eq((String)"id", (Object)model.getDetailId())}), (Bson)new Document("$set", (Object)Document.parse((String)JsonHandler.writeAsString((Object)model))).append("$setOnInsert", (Object)new Document("_id", (Object)GUIDFactory.newGUID().toString())), new UpdateOptions().upsert(true));
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void bulkAppendReport(List<UpdateUnitMetadataReportEntry> reports) {
        List preservationDocument = reports.stream().distinct().map(UpdateUnitReportRepository::modelToWriteDocument).collect(Collectors.toList());
        this.collection.bulkWrite(preservationDocument);
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        return this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), PROJECTION)).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.collection);
    }
}

