/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.TraceabilityObjectModel;
import fr.gouv.vitam.batch.report.model.TraceabilityStatsModel;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TraceabilityReportRepository
extends ReportCommonRepository {
    public static final String TRACEABILITY_REPORT = "TraceabilityReport";
    private final MongoCollection<Document> traceabilityReportCollection;
    private final String RESULT = "result";
    private final String OPERATION_PROJECTION = "$%s.%s";

    public TraceabilityReportRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, TRACEABILITY_REPORT);
    }

    @VisibleForTesting
    TraceabilityReportRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.traceabilityReportCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public MongoCursor<Document> findCollection(String processId, int tenantId) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        Bson aggregation = Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant}));
        return this.traceabilityReportCollection.aggregate(Collections.singletonList(aggregation)).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public TraceabilityStatsModel stats(String processId, Integer tenantId) {
        TraceabilityStatsModel traceabilityStatsModel = new TraceabilityStatsModel(0, 0, 0, 0);
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        Bson aggregation = Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant}));
        Bson groupBy = Aggregates.group((Object)String.format("$%s.%s", "_metadata", "operationType"), (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        Bson projections = Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"_metadata"})}));
        MongoCursor iterator = this.traceabilityReportCollection.aggregate(Arrays.asList(aggregation, projections, groupBy)).allowDiskUse(Boolean.valueOf(true)).iterator();
        iterator.forEachRemaining(result -> {
            String operationType = result.getString((Object)"_id");
            Integer count = result.getInteger((Object)"result");
            traceabilityStatsModel.addOneModel(operationType, count);
        });
        return traceabilityStatsModel;
    }

    public ReportResults computeVitamResults(String processId, Integer tenantId) {
        ReportResults reportResult = new ReportResults();
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        Bson aggregation = Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant}));
        Bson groupBy = Aggregates.group((Object)String.format("$%s.%s", "_metadata", "status"), (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        Bson projections = Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"_metadata"})}));
        MongoCursor iterator = this.traceabilityReportCollection.aggregate(Arrays.asList(aggregation, projections, groupBy)).allowDiskUse(Boolean.valueOf(true)).iterator();
        iterator.forEachRemaining(result -> {
            String status = result.getString((Object)"_id");
            Integer count = result.getInteger((Object)"result");
            reportResult.addOneStatus(status, count);
        });
        return reportResult;
    }

    public void bulkAppendReport(List<TraceabilityObjectModel> reports) {
        HashSet<TraceabilityObjectModel> reportsWithoutDuplicate = new HashSet<TraceabilityObjectModel>(reports);
        List<Document> traceabilityObjectDocument = reportsWithoutDuplicate.stream().map(ReportCommonRepository::pojoToDocument).collect(Collectors.toList());
        super.bulkAppendReport(traceabilityObjectDocument, this.traceabilityReportCollection);
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.traceabilityReportCollection);
    }
}

