/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import fr.gouv.vitam.batch.report.model.PreservationStatsModel;
import fr.gouv.vitam.batch.report.model.PreservationStatus;
import fr.gouv.vitam.batch.report.model.entry.PreservationReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.ActionTypePreservation;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PreservationReportRepository {
    private final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationReportRepository.class);
    public static final String PRESERVATION_REPORT = "PreservationReport";
    private final MongoCollection<Document> collection;

    @VisibleForTesting
    public PreservationReportRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.collection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public PreservationReportRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, PRESERVATION_REPORT);
    }

    public void bulkAppendReport(List<PreservationReportEntry> reports) {
        List preservationDocument = reports.stream().distinct().map(PreservationReportRepository::modelToWriteDocument).collect(Collectors.toList());
        this.collection.bulkWrite(preservationDocument);
    }

    private static WriteModel<Document> modelToWriteDocument(PreservationReportEntry model) {
        return new UpdateOneModel(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)model.getProcessId()), Filters.eq((String)"id", (Object)model.getDetailId())}), (Bson)new Document("$set", (Object)Document.parse((String)JsonHandler.unprettyPrint((Object)model))).append("$setOnInsert", (Object)new Document("_id", (Object)GUIDFactory.newGUID().toString())), new UpdateOptions().upsert(true));
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        return this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("processId", (Object)"$processId"), new Document("creationDateTime", (Object)"$creationDateTime"), new Document("unitId", (Object)"$unitId"), new Document("objectGroupId", (Object)"$objectGroupId"), new Document("status", (Object)"$status"), new Document("action", (Object)"$actions"), new Document("analyseResult", (Object)"$analyseResult"), new Document("inputObjectId", (Object)"$inputObjectId"), new Document("outputObjectId", (Object)"$outputObjectId"), new Document("griffinId", (Object)"$griffinId"), new Document("preservationScenarioId", (Object)"$preservationScenarioId")})))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public PreservationStatsModel stats(String processId, int tenantId) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        int nbUnits = this.getUnitAndObjectGroupStats(Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant}), "unitId");
        int nbObjectGroups = this.getUnitAndObjectGroupStats(Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant}), "objectGroupId");
        int nbStatusKos = this.getStats(Filters.and((Bson[])new Bson[]{eqTenant, eqProcessId, Filters.eq((String)"status", (Object)PreservationStatus.KO.name())}), "status");
        int nbStatusWarning = this.getStats(Filters.and((Bson[])new Bson[]{eqTenant, eqProcessId, Filters.eq((String)"status", (Object)PreservationStatus.WARNING.name())}), "status");
        int nbActionsAnaylse = this.getStats(Filters.and((Bson[])new Bson[]{eqTenant, eqProcessId, Filters.eq((String)"action", (Object)ActionTypePreservation.ANALYSE.name())}), "action");
        int nbActionsGenerate = this.getStats(Filters.and((Bson[])new Bson[]{eqTenant, eqProcessId, Filters.eq((String)"action", (Object)ActionTypePreservation.GENERATE.name())}), "action");
        int nbActionsIdentify = this.getStats(Filters.and((Bson[])new Bson[]{eqTenant, eqProcessId, Filters.eq((String)"action", (Object)ActionTypePreservation.IDENTIFY.name())}), "action");
        int nbActionsExtract = this.getStats(Filters.and((Bson[])new Bson[]{eqTenant, eqProcessId, Filters.eq((String)"action", (Object)ActionTypePreservation.EXTRACT.name())}), "action");
        Spliterator mapAnalyseResult = nbActionsAnaylse > 0 ? this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqTenant, eqProcessId})), Aggregates.project((Bson)Projections.include((String[])new String[]{"analyseResult"})), Aggregates.group((Object)"$analyseResult", (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)}))).allowDiskUse(Boolean.valueOf(true)).batchSize(VitamConfiguration.getBatchSize()).map(d -> new AbstractMap.SimpleEntry<String, Integer>(d.getString((Object)"_id"), (Integer)d.get((Object)"count", Integer.class))).spliterator() : Spliterators.emptySpliterator();
        Map<String, Integer> analyseResults = StreamSupport.stream(mapAnalyseResult, false).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        return new PreservationStatsModel(nbUnits, nbObjectGroups, nbStatusKos, nbActionsAnaylse, nbActionsGenerate, nbActionsIdentify, nbActionsExtract, analyseResults, nbStatusWarning);
    }

    private Integer getStats(Bson matchee, String name) {
        Document result = (Document)this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)matchee), Aggregates.group((Object)String.format("$%s", name), (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)}))).first();
        return result != null ? result.getInteger((Object)"result") : 0;
    }

    private Integer getUnitAndObjectGroupStats(Bson matchee, String name) {
        HashMap<String, Document> group = new HashMap<String, Document>();
        group.put("_id", null);
        group.put("count", new Document("$sum", (Object)1));
        Document first = (Document)this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)matchee), Aggregates.group((Object)String.format("$%s", name), (BsonField[])new BsonField[0]), new Document("$group", group))).first();
        if (first != null) {
            return first.getInteger((Object)"count");
        }
        return 0;
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        DeleteResult deleteResult = this.collection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)}));
        this.LOGGER.info("Deleted document count: " + deleteResult.getDeletedCount() + " for process " + processId);
    }
}

