/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import fr.gouv.vitam.batch.report.model.EvidenceAuditFullStatusCount;
import fr.gouv.vitam.batch.report.model.EvidenceAuditObjectModel;
import fr.gouv.vitam.batch.report.model.EvidenceAuditStatsModel;
import fr.gouv.vitam.batch.report.model.EvidenceAuditStatusCount;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class EvidenceAuditReportRepository
extends ReportCommonRepository {
    public static final String EVIDENCE_AUDIT = "EvidenceAuditReport";
    private final MongoCollection<Document> evidenceAuditReportCollection;

    @VisibleForTesting
    public EvidenceAuditReportRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.evidenceAuditReportCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public EvidenceAuditReportRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, EVIDENCE_AUDIT);
    }

    public void bulkAppendReport(List<EvidenceAuditObjectModel> reports) {
        HashSet<EvidenceAuditObjectModel> reportsWithoutDuplicate = new HashSet<EvidenceAuditObjectModel>(reports);
        List<Document> evidenceAuditObjectGroupDocument = reportsWithoutDuplicate.stream().map(ReportCommonRepository::pojoToDocument).collect(Collectors.toList());
        super.bulkAppendReport(evidenceAuditObjectGroupDocument, this.evidenceAuditReportCollection);
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.evidenceAuditReportCollection);
    }

    public ReportResults computeVitamResults(String processId, Integer tenantId) {
        ReportResults reportResult = new ReportResults();
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        EvidenceAuditFullStatusCount globalResults = new EvidenceAuditFullStatusCount(new EvidenceAuditStatusCount(), new EvidenceAuditStatusCount(), new EvidenceAuditStatusCount());
        this.getNbObjects(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant})), globalResults);
        this.getMetadataTypeStats(globalResults, eqProcessId, eqTenant);
        reportResult.setNbOk(Integer.valueOf(globalResults.getObjectGroupsCount().getNbOK() + globalResults.getUnitsCount().getNbOK() + globalResults.getObjectsCount().getNbOK()));
        reportResult.setNbKo(Integer.valueOf(globalResults.getObjectGroupsCount().getNbKO() + globalResults.getUnitsCount().getNbKO() + globalResults.getObjectsCount().getNbKO()));
        reportResult.setNbWarning(Integer.valueOf(globalResults.getObjectGroupsCount().getNbWARNING() + globalResults.getUnitsCount().getNbWARNING() + globalResults.getObjectsCount().getNbWARNING()));
        return reportResult;
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        return this.evidenceAuditReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant})), Aggregates.project((Bson)this.evidenceReportProjection()))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public MongoCursor<Document> findCollectionByProcessIdTenantAndStatus(String processId, int tenantId, String ... status) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        Bson inStatus = Filters.in((String)"_metadata.status", (Object[])status);
        return this.evidenceAuditReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant, inStatus})), Aggregates.project((Bson)this.evidenceReportProjection()))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public EvidenceAuditStatsModel stats(String processId, int tenantId) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        EvidenceAuditFullStatusCount globalResults = new EvidenceAuditFullStatusCount(new EvidenceAuditStatusCount(), new EvidenceAuditStatusCount(), new EvidenceAuditStatusCount());
        this.getNbObjects(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant})), globalResults);
        this.getMetadataTypeStats(globalResults, eqProcessId, eqTenant);
        return new EvidenceAuditStatsModel(globalResults.getObjectGroupsCount().getTotal(), globalResults.getUnitsCount().getTotal(), globalResults.getObjectsCount().getTotal(), globalResults);
    }

    private void getNbObjects(Bson matchAgg, EvidenceAuditFullStatusCount results) {
        Bson group = Aggregates.group((Object)"$_metadata.objectsReports.status", (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        MongoCursor<Document> objectGroupsStatusCountResult = this.getListStats(matchAgg, Aggregates.unwind((String)"$_metadata.objectsReports"), group);
        while (objectGroupsStatusCountResult.hasNext()) {
            Document result = (Document)objectGroupsStatusCountResult.next();
            String status = result.getString((Object)"_id");
            Integer count = result.getInteger((Object)"result");
            results.getObjectsCount().addOneStatus(status, count.intValue());
        }
    }

    private void getMetadataTypeStats(EvidenceAuditFullStatusCount globalResults, Bson eqProcessId, Bson eqTenant) {
        MongoCursor<Document> findIterable = this.getListStats(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant})), Aggregates.group((Object)new Document("_id", (Object)new Document("restType", (Object)"$_metadata.objectType").append("resStatus", (Object)"$_metadata.status")), (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)}));
        while (findIterable.hasNext()) {
            Document current = (Document)findIterable.next();
            Document objectType = (Document)current.get((Object)"_id");
            String dataType = ((Document)objectType.get((Object)"_id")).get((Object)"restType").toString();
            String dataStatus = ((Document)objectType.get((Object)"_id")).getString((Object)"resStatus");
            Integer count = current.getInteger((Object)"result");
            switch (dataType) {
                case "OBJECTGROUP": {
                    globalResults.getObjectGroupsCount().addOneStatus(dataStatus, count.intValue());
                    break;
                }
                case "UNIT": {
                    globalResults.getUnitsCount().addOneStatus(dataStatus, count.intValue());
                    break;
                }
            }
        }
    }

    private Bson evidenceReportProjection() {
        return Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("identifier", (Object)"$_metadata.identifier"), new Document("status", (Object)"$_metadata.status"), new Document("objectType", (Object)"$_metadata.objectType"), new Document("message", (Object)"$_metadata.message"), new Document("strategyId", (Object)"$_metadata.strategyId"), new Document("offersHashes", (Object)"$_metadata.offersHashes")});
    }

    private MongoCursor<Document> getListStats(Bson ... aggregations) {
        return this.evidenceAuditReportCollection.aggregate(Arrays.asList(aggregations)).allowDiskUse(Boolean.valueOf(true)).iterator();
    }
}

