/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.adapter.SingleVarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.functional.administration.core.security.profile.SecurityProfileService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class SecurityProfileResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SecurityProfileResource.class);
    public static final String SECURITY_PROFILE_URI = "/securityprofiles";
    private static final String ADMIN_MODULE = "ADMIN_MODULE";
    private static final String SECURITY_PROFILE_JSON_IS_MANDATORY_PARAMETER = "The json input of security profiles is mandatory";
    private final SecurityProfileService securityProfileService;

    public SecurityProfileResource(SecurityProfileService securityProfileService) {
        this.securityProfileService = securityProfileService;
        LOGGER.debug("init Admin Management Resource server");
    }

    @Path(value="/securityprofiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importSecurityProfiles(List<SecurityProfileModel> securityProfileModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)SECURITY_PROFILE_JSON_IS_MANDATORY_PARAMETER, (Object[])new Object[]{securityProfileModelList});
        try {
            RequestResponse requestResponse = this.securityProfileService.createSecurityProfiles(securityProfileModelList);
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    @GET
    @Path(value="/securityprofiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findSecurityProfiles(JsonNode queryDsl) {
        try {
            RequestResponseOK securityProfileModelList = this.securityProfileService.findSecurityProfiles(queryDsl).setQuery(queryDsl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)securityProfileModelList).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
    }

    @GET
    @Path(value="/securityprofiles/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findSecurityProfileByIdentifier(@PathParam(value="id") String identifier) {
        try {
            SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new SingleVarNameAdapter());
            parser.parse((JsonNode)new Select().getFinalSelect());
            parser.addCondition((Query)QueryHelper.eq((String)"Identifier", (String)identifier));
            ObjectNode queryDsl = parser.getRequest().getFinalSelect();
            RequestResponseOK securityProfileModelList = this.securityProfileService.findSecurityProfiles((JsonNode)queryDsl).setQuery((JsonNode)queryDsl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)securityProfileModelList).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
    }

    @Path(value="/securityprofiles/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateSecurityProfile(@PathParam(value="id") String identifier, JsonNode queryDsl) {
        try {
            RequestResponse requestResponse = this.securityProfileService.updateSecurityProfile(identifier, queryDsl);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
            }
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    Response deleteSecurityProfile(String securityProfileId) {
        try {
            RequestResponse requestResponse = this.securityProfileService.deleteSecurityProfile(securityProfileId);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
            }
            if (Response.Status.FORBIDDEN.getStatusCode() == requestResponse.getHttpCode()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)requestResponse).build();
            }
            if (!requestResponse.isOk()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)requestResponse).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    private VitamError<SecurityProfileModel> getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(ADMIN_MODULE).setState("code_vitam").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

