/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamThreadAccessException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ProfileNotFoundException;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.profile.ProfileServiceImpl;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class ProfileResource {
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProfileResource.class);
    private static final String PROFILE_JSON_IS_MANDATORY_PATAMETER = "The json input of profile is mandatory";
    private static final String PROFILE_FILE_IS_MANDATORY_PATAMETER = "The profile file is mandatory";
    private static final String PROFILE_ID_IS_MANDATORY_PATAMETER = "The profile id is mandatory";
    private static final String DSL_QUERY_IS_MANDATORY_PATAMETER = "The dsl query is mandatory";
    public static final String PROFILE_URI = "/profiles";
    public static final String UPDATE_PROFIL_URI = "/profiles";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final VitamCounterService vitamCounterService;
    private final FunctionalBackupService functionalBackupService;

    public ProfileResource(AdminManagementConfiguration configuration, MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        this.functionalBackupService = functionalBackupService;
        WorkspaceClientFactory.changeMode((String)configuration.getWorkspaceUrl(), (WorkspaceType)WorkspaceType.VITAM);
        LOGGER.debug("init Admin Management Resource server");
    }

    @VisibleForTesting
    public ProfileResource(WorkspaceClientFactory workspaceClientFactory, MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = mongoAccess;
        this.workspaceClientFactory = workspaceClientFactory;
        this.vitamCounterService = vitamCounterService;
        this.functionalBackupService = functionalBackupService;
        LOGGER.debug("init Admin Management Resource server");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/profiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createProfiles(List<ProfileModel> profileModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)PROFILE_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{profileModelList});
        try (ProfileServiceImpl profileService = new ProfileServiceImpl(this.mongoAccess, this.vitamCounterService, this.functionalBackupService);){
            RequestResponse requestResponse = profileService.createProfiles(profileModelList);
            if (!requestResponse.isOk()) {
                Response response = Response.status((int)requestResponse.getHttpCode()).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/profiles/{id}")
    @PUT
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response importProfileFile(@Context UriInfo uri, @PathParam(value="id") String profileMetadataId, InputStream profileFile) {
        ParametersChecker.checkParameter((String)PROFILE_FILE_IS_MANDATORY_PATAMETER, (Object[])new Object[]{profileFile});
        ParametersChecker.checkParameter((String)PROFILE_ID_IS_MANDATORY_PATAMETER, (String[])new String[]{profileMetadataId});
        try {
            RequestResponse requestResponse;
            ProfileServiceImpl profileService;
            block14: {
                Response response;
                profileService = new ProfileServiceImpl(this.mongoAccess, this.vitamCounterService, this.functionalBackupService);
                try {
                    SanityChecker.checkParameter((String[])new String[]{profileMetadataId});
                    requestResponse = profileService.importProfileFile(profileMetadataId, profileFile);
                    if (requestResponse.isOk()) break block14;
                    response = Response.status((int)requestResponse.getHttpCode()).entity((Object)requestResponse).build();
                }
                catch (Throwable throwable) {
                    Response response2;
                    try {
                        try {
                            profileService.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (VitamException exp) {
                        LOGGER.error((Throwable)exp);
                        response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
                        return response2;
                    }
                    catch (Exception exp) {
                        LOGGER.error("Unexpected server error {}", (Throwable)exp);
                        response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
                        return response2;
                    }
                }
                profileService.close();
                return response;
            }
            Response response = Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
            profileService.close();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)profileFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/profiles/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateProfileFile(@PathParam(value="id") String profileMetadataId, JsonNode queryDsl) {
        ParametersChecker.checkParameter((String)PROFILE_ID_IS_MANDATORY_PATAMETER, (String[])new String[]{profileMetadataId});
        ParametersChecker.checkParameter((String)DSL_QUERY_IS_MANDATORY_PATAMETER, (Object[])new Object[]{queryDsl});
        try (ProfileServiceImpl profileService = new ProfileServiceImpl(this.mongoAccess, this.vitamCounterService, this.functionalBackupService);){
            SanityChecker.checkParameter((String[])new String[]{profileMetadataId});
            RequestResponse requestResponse = profileService.updateProfile(profileMetadataId, queryDsl);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
                return response;
            }
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage(), null)).build();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected server error {}", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
    }

    @GET
    @Path(value="/profiles/{id}")
    @Produces(value={"application/octet-stream"})
    public Response downloadProfileFile(@PathParam(value="id") String profileMetadataId) {
        Response response;
        try {
            ParametersChecker.checkParameter((String)"Profile id should be filled", (String[])new String[]{profileMetadataId});
        }
        catch (VitamThreadAccessException | IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
        ProfileServiceImpl profileService = new ProfileServiceImpl(this.mongoAccess, this.vitamCounterService, this.functionalBackupService);
        try {
            response = profileService.downloadProfileFile(profileMetadataId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    profileService.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ProfileNotFoundException exc) {
                LOGGER.error(exc.getMessage(), (Throwable)exc);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream(Response.Status.NOT_FOUND, exc.getMessage(), null).toString()).build();
            }
            catch (Exception exc) {
                LOGGER.error(exc.getMessage(), (Throwable)exc);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage(), null).toString()).build();
            }
        }
        profileService.close();
        return response;
    }

    @GET
    @Path(value="/profiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findProfiles(JsonNode queryDsl) {
        Response response;
        ProfileServiceImpl profileService = new ProfileServiceImpl(this.mongoAccess, this.vitamCounterService, this.functionalBackupService);
        try {
            RequestResponseOK profileModelList = profileService.findProfiles(queryDsl).setQuery(queryDsl);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)profileModelList).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    profileService.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
            }
        }
        profileService.close();
        return response;
    }

    private VitamError getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("ko").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    private InputStream getErrorStream(Response.Status status, String message, String code) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        try {
            return JsonHandler.writeToInpustream((Object)new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("ko").setMessage(status.getReasonPhrase()).setDescription(aMessage));
        }
        catch (InvalidParseOperationException e) {
            return new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
    }
}

