/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.core.griffin.GriffinService;
import fr.gouv.vitam.functional.administration.core.griffin.PreservationScenarioService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class PreservationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationResource.class);
    private final PreservationScenarioService preservationScenarioService;
    private final GriffinService griffinService;

    PreservationResource(PreservationScenarioService preservationScenarioService, GriffinService griffinService) {
        this.preservationScenarioService = preservationScenarioService;
        this.griffinService = griffinService;
    }

    @POST
    @Path(value="/importGriffins")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importGriffin(List<GriffinModel> griffinModelList, @Context UriInfo uri) {
        try {
            RequestResponse requestResponse = this.griffinService.importGriffin(griffinModelList);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)requestResponse).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_VALIDATION_ERROR, e.getMessage());
        }
    }

    @POST
    @Path(value="/importPreservationScenarios")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importPreservationScenario(List<PreservationScenarioModel> preservationScenarioModel, @Context UriInfo uri) {
        try {
            RequestResponse requestResponse = this.preservationScenarioService.importScenarios(preservationScenarioModel);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)requestResponse).build();
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected server error {}", (Throwable)e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_INTERNAL_ERROR, e.getMessage());
        }
    }

    private Response buildErrorResponse(VitamCode vitamCode, String message) {
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)(new RequestResponseError().setError(new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(vitamCode.getMessage())).toString() + message)).build();
    }

    @GET
    @Path(value="/griffin")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findGriffin(JsonNode queryDsl) {
        try {
            RequestResponse requestResponse = this.griffinService.findGriffin(queryDsl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Unexpected server error {}", (Throwable)e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_VALIDATION_ERROR, e.getMessage());
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @GET
    @Path(value="/preservationScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findPreservation(JsonNode queryDsl) {
        try {
            RequestResponse requestResponse = this.preservationScenarioService.findPreservationScenario(queryDsl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Unexpected server error {}", (Throwable)e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_VALIDATION_ERROR, e.getMessage());
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

