/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.functional.administration.core.context.ContextService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class ContextResource {
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    static final String CONTEXTS_URI = "/contexts";
    static final String UPDATE_CONTEXT_URI = "/context";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ContextResource.class);
    private static final String CONTEXTS_JSON_IS_MANDATORY_PATAMETER = "The json input of contexts is mandatory";
    private final ContextService contextService;

    public ContextResource(ContextService contextService) {
        this.contextService = contextService;
        LOGGER.debug("init Admin Management Resource server");
    }

    @Path(value="/contexts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importContexts(List<ContextModel> ContextModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)CONTEXTS_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{ContextModelList});
        try {
            RequestResponse requestResponse = this.contextService.createContexts(ContextModelList);
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
        }
        catch (ReferentialException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("ko").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    @GET
    @Path(value="/contexts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findContexts(JsonNode queryDsl) {
        Response response;
        block8: {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            DbRequestResult result = this.contextService.findContexts(queryDsl);
            try {
                RequestResponseOK response2 = result.getRequestResponseOK(queryDsl, fr.gouv.vitam.functional.administration.common.Context.class, ContextModel.class);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
                }
            }
            result.close();
        }
        return response;
    }

    @Path(value="/context/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateContexts(@PathParam(value="id") String contextId, JsonNode queryDsl) {
        try {
            RequestResponse requestResponse = this.contextService.updateContext(contextId, queryDsl);
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
        }
        catch (ReferentialNotFoundException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorEntity(Response.Status.NOT_FOUND, exp.getMessage(), null)).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    Response deleteContext(String contextId, boolean force) {
        try {
            RequestResponse requestResponse = this.contextService.deleteContext(contextId, force);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
            }
            if (Response.Status.FORBIDDEN.getStatusCode() == requestResponse.getHttpCode()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)requestResponse).build();
            }
            if (!requestResponse.isOk()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)requestResponse).build();
        }
        catch (ReferentialNotFoundException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorEntity(Response.Status.NOT_FOUND, exp.getMessage(), null)).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }
}

