/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.functional.administration.common.Agencies;
import fr.gouv.vitam.functional.administration.core.agencies.AgenciesImportResult;
import fr.gouv.vitam.functional.administration.core.agencies.AgenciesService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class AgenciesResource {
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    static final String AGENCIES = "/agencies";
    static final String AGENCIES_IMPORT = "/agencies/import";
    static final String AGENCIES_CHECK = "/agencies/check";
    private static final String ATTACHEMENT_FILENAME = "attachment; filename=ErrorReport.json";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AgenciesResource.class);
    private static final String AGENCIES_FILES_IS_MANDATORY_PATAMETER = "The json input of agency is mandatory";
    private final AgenciesService agenciesService;

    public AgenciesResource(AgenciesService agenciesService) {
        this.agenciesService = agenciesService;
        LOGGER.debug("init Admin Management Resource server");
    }

    @Path(value="/agencies/import")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response importAgencies(@Context HttpHeaders headers, InputStream inputStream, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)AGENCIES_FILES_IS_MANDATORY_PATAMETER, (Object[])new Object[]{inputStream});
        try {
            String filename = headers.getHeaderString("X-Filename");
            RequestResponse requestResponse = this.agenciesService.importAgencies(inputStream, filename);
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage())).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage())).build();
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(String.valueOf(status.getStatusCode())).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("ko").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    @Path(value="/agencies")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAgencies(JsonNode queryDsl) {
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            DbRequestResult agenciesModelList = this.agenciesService.findAgencies(queryDsl);
            RequestResponseOK reponse = agenciesModelList.getRequestResponseOK(queryDsl, Agencies.class, AgenciesModel.class);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)reponse).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    @Path(value="/agencies/check")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    public Response checkAgenciesFile(InputStream agencyStream) {
        ParametersChecker.checkParameter((String)"agenciessStream is a mandatory parameter", (Object[])new Object[]{agencyStream});
        try {
            File file = FileUtil.convertInputStreamToFile((InputStream)agencyStream, (String)GUIDFactory.newGUID().getId());
            this.agenciesService.parseFile(file);
            InputStream errorReportInputStream = this.agenciesService.generateErrorReport(new AgenciesImportResult());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/octet-stream");
            headers.put("Content-Disposition", ATTACHEMENT_FILENAME);
            return new VitamAsyncInputStreamResponse(errorReportInputStream, Response.Status.OK, headers);
        }
        catch (Exception e) {
            return this.handleGenerateReport();
        }
    }

    private Response handleGenerateReport() {
        try {
            InputStream errorReportInputStream = this.agenciesService.generateErrorReport(new AgenciesImportResult());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/octet-stream");
            headers.put("Content-Disposition", ATTACHEMENT_FILENAME);
            return new VitamAsyncInputStreamResponse(errorReportInputStream, Response.Status.BAD_REQUEST, headers);
        }
        catch (Exception e1) {
            LOGGER.error((Throwable)e1);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

