/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.rest.SecurityProfileResource;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/admin")
@Tag(name="Functional-Administration")
public class AdminSecurityProfileResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminSecurityProfileResource.class);
    private SecurityProfileResource securityProfileResource;
    public static final int ADMIN_TENANT = VitamConfiguration.getAdminTenant();

    public AdminSecurityProfileResource(SecurityProfileResource securityProfileResource) {
        LOGGER.debug("init Admin Management Resource server");
        this.securityProfileResource = securityProfileResource;
    }

    @Path(value="/securityprofiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importSecurityProfiles(List<SecurityProfileModel> securityProfileModelList, @Context UriInfo uri) {
        LOGGER.info("create security profile with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.securityProfileResource.importSecurityProfiles(securityProfileModelList, uri);
    }

    @Path(value="/securityprofiles")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findContexts(JsonNode queryDsl) {
        LOGGER.info("find security profile with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.securityProfileResource.findSecurityProfiles(queryDsl);
    }

    @Path(value="/securityprofiles/{securityprofileId}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteContext(@PathParam(value="securityprofileId") String securityProfileId) {
        LOGGER.info("delete security profile with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.securityProfileResource.deleteSecurityProfile(securityProfileId);
    }
}

