/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.ProcessingEntry;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextModel;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextMonitor;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/adminmanagement/v1")
@Tag(name="Functional-Administration")
public class AdminOperationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminOperationResource.class);
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;

    public AdminOperationResource() {
        this(WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), ProcessingManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    public AdminOperationResource(WorkspaceClientFactory workspaceClientFactory, ProcessingManagementClientFactory processingManagementClientFactory) {
        this.workspaceClientFactory = workspaceClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Path(value="invalidIngestCleanup/{ingestOperationId}")
    @POST
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response startIngestCleanupWorkflow(@PathParam(value="ingestOperationId") String ingestOperationId, @HeaderParam(value="X-Tenant-Id") Integer tenantId) {
        ParametersChecker.checkParameter((String)"Missing tenant", (Object[])new Object[]{tenantId});
        VitamThreadUtils.getVitamSession().setTenantId(tenantId);
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)tenantId));
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();){
            Response response;
            block14: {
                WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
                try {
                    workspaceClient.createContainer(operationId);
                    this.createCleanupLogbookOperation(operationId);
                    ProcessingEntry entry = new ProcessingEntry(operationId, Contexts.INGEST_CLEANUP.name());
                    entry.getExtraParams().put(WorkerParameterName.ingestOperationIdToCleanup.name(), ingestOperationId);
                    workspaceClient.putObject(operationId, "operation_context.json", JsonHandler.writeToInpustream((Object)OperationContextModel.get((Object)entry)));
                    OperationContextMonitor.compressInWorkspace((WorkspaceClientFactory)this.workspaceClientFactory, (String)operationId, (LogbookTypeProcess)Contexts.INGEST_CLEANUP.getLogbookTypeProcess(), (String[])new String[]{"operation_context.json"});
                    processingClient.initVitamProcess(entry);
                    processingClient.updateOperationActionProcess(ProcessAction.RESUME.getValue(), operationId);
                    LOGGER.info("Cleanup started successfully");
                    response = Response.status((Response.Status)Response.Status.ACCEPTED).header("X-Request-Id", (Object)VitamThreadUtils.getVitamSession().getRequestId()).entity((Object)new RequestResponseOK().setHttpCode(Response.Status.ACCEPTED.getStatusCode())).build();
                    if (workspaceClient == null) break block14;
                }
                catch (Throwable throwable) {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workspaceClient.close();
            }
            return response;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during cleanup", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).header("X-Request-Id", (Object)VitamThreadUtils.getVitamSession().getRequestId()).entity((Object)this.getErrorEntity(status, e.getLocalizedMessage())).build();
        }
    }

    private void createCleanupLogbookOperation(String operationId) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException, InvalidGuidOperationException {
        GUID objectId = GUIDReader.getGUID((String)operationId);
        try (LogbookOperationsClient logbookClient = LogbookOperationsClientFactory.getInstance().getClient();){
            LogbookOperationParameters initParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)objectId, (String)Contexts.INGEST_CLEANUP.getEventType(), (GUID)objectId, (LogbookTypeProcess)LogbookTypeProcess.INTERNAL_OPERATING_OP, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)Contexts.INGEST_CLEANUP.getEventType(), (StatusCode)StatusCode.STARTED), (GUID)objectId);
            initParameters.putParameterValue(LogbookParameterName.objectIdentifierRequest, operationId);
            logbookClient.create(new LogbookOperationParameters[]{initParameters});
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = StringUtils.isNotEmpty((CharSequence)message) ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState(status.name()).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

