/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.collections.CachedOntologyLoader;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.functional.administration.common.client.FunctionAdministrationOntologyLoader;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfigurationValidator;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.context.ContextService;
import fr.gouv.vitam.functional.administration.core.context.ContextServiceImpl;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyService;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyServiceImpl;
import fr.gouv.vitam.functional.administration.core.security.profile.SecurityProfileService;
import fr.gouv.vitam.functional.administration.rest.AdminContextResource;
import fr.gouv.vitam.functional.administration.rest.AdminManagementResource;
import fr.gouv.vitam.functional.administration.rest.AdminMigrationResource;
import fr.gouv.vitam.functional.administration.rest.AdminOntologyResource;
import fr.gouv.vitam.functional.administration.rest.AdminOperationResource;
import fr.gouv.vitam.functional.administration.rest.AdminSecurityProfileResource;
import fr.gouv.vitam.functional.administration.rest.ContextResource;
import fr.gouv.vitam.functional.administration.rest.OntologyResource;
import fr.gouv.vitam.functional.administration.rest.ReindexationResource;
import fr.gouv.vitam.functional.administration.rest.SecurityProfileResource;
import fr.gouv.vitam.security.internal.filter.AdminRequestIdFilter;
import fr.gouv.vitam.security.internal.filter.BasicAuthenticationFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class AdminFunctionalApplication
extends Application {
    private final Set<Object> singletons;

    public AdminFunctionalApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        AdminApplication adminApplication = new AdminApplication();
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            AdminManagementConfiguration configuration = (AdminManagementConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, AdminManagementConfiguration.class);
            AdminManagementConfigurationValidator.validateConfiguration((AdminManagementConfiguration)configuration);
            ElasticsearchFunctionalAdminIndexManager indexManager = new ElasticsearchFunctionalAdminIndexManager(configuration);
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(adminApplication.getSingletons());
            CachedOntologyLoader ontologyLoader = new CachedOntologyLoader(VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (OntologyLoader)new FunctionAdministrationOntologyLoader());
            AdminManagementResource resource = new AdminManagementResource(configuration, (OntologyLoader)ontologyLoader, indexManager);
            MongoDbAccessAdminImpl mongoDbAccess = resource.getLogbookDbAccess();
            this.singletons.add(new ReindexationResource(indexManager));
            Map externalIdentifiers = configuration.getListEnableExternalIdentifiers();
            VitamCounterService vitamCounterService = new VitamCounterService(mongoDbAccess, VitamConfiguration.getTenants(), externalIdentifiers);
            FunctionalBackupService functionalBackupService = new FunctionalBackupService(vitamCounterService);
            SecurityProfileService securityProfileService = new SecurityProfileService(mongoDbAccess, vitamCounterService, functionalBackupService);
            ContextServiceImpl contextService = new ContextServiceImpl(mongoDbAccess, vitamCounterService);
            securityProfileService.setContextService((ContextService)contextService);
            contextService.setSecurityProfileService(securityProfileService);
            ContextResource contextResource = new ContextResource((ContextService)contextService);
            OntologyServiceImpl ontologyService = new OntologyServiceImpl(mongoDbAccess, functionalBackupService);
            AdminContextResource adminContextResource = new AdminContextResource(contextResource);
            this.singletons.add(adminContextResource);
            OntologyResource ontologyResource = new OntologyResource((OntologyService)ontologyService);
            AdminOntologyResource adminOntologyResource = new AdminOntologyResource(ontologyResource, (OntologyService)ontologyService);
            this.singletons.add(adminOntologyResource);
            SecurityProfileResource securityProfileResource = new SecurityProfileResource(securityProfileService);
            AdminSecurityProfileResource adminSecurityProfileResource = new AdminSecurityProfileResource(securityProfileResource);
            this.singletons.add(adminSecurityProfileResource);
            this.singletons.add(new AdminMigrationResource(configuration, (OntologyLoader)ontologyLoader, indexManager));
            this.singletons.add(new AdminOperationResource());
            this.singletons.add(new BasicAuthenticationFilter((DefaultVitamApplicationConfiguration)configuration));
            this.singletons.add(new AdminRequestIdFilter());
        }
        catch (VitamException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

