/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.rest.ContextResource;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/admin")
@Tag(name="Functional-Administration")
public class AdminContextResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminContextResource.class);
    private ContextResource contextResource;
    public static final int ADMIN_TENANT = VitamConfiguration.getAdminTenant();

    public AdminContextResource(ContextResource contextResource) {
        LOGGER.debug("init Admin Management Resource server");
        this.contextResource = contextResource;
    }

    @Path(value="/contexts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importContexts(List<ContextModel> contextModelList, @Context UriInfo uri) {
        LOGGER.info("create context with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.contextResource.importContexts(contextModelList, uri);
    }

    @Path(value="/contexts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findContexts(JsonNode queryDsl) {
        LOGGER.info("find context with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.contextResource.findContexts(queryDsl);
    }

    @Path(value="/context/{contextId}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteContext(@PathParam(value="contextId") String contextId) {
        LOGGER.info("delete context with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.contextResource.deleteContext(contextId, true);
    }
}

