/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.Step;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessStep
extends Step {
    private AtomicLong elementProcessed = new AtomicLong(0L);
    private AtomicLong elementToProcess = new AtomicLong(0L);
    private StatusCode stepStatusCode = StatusCode.UNKNOWN;
    @JsonIgnore
    private boolean lastStep = false;

    @VisibleForTesting
    public ProcessStep(Step step, AtomicLong elementToProcess, AtomicLong elementProcessed, String id) {
        this(step, elementToProcess, elementProcessed);
        this.setId(id);
    }

    public ProcessStep(Step step, AtomicLong elementToProcess, AtomicLong elementProcessed) {
        ParametersChecker.checkParameter((String)"Step could not be null", (Object[])new Object[]{step});
        this.setActions(step.getActions());
        this.setDistribution(step.getDistribution());
        this.setStepName(step.getStepName());
        this.setBehavior(step.getBehavior());
        this.setWorkerGroupId(step.getWorkerGroupId());
        this.setId(step.getId());
        this.elementProcessed = elementProcessed;
        this.elementToProcess = elementToProcess;
    }

    @VisibleForTesting
    public ProcessStep(Step step, String id, String containerName, String workflowId, int position, AtomicLong elementToProcess, AtomicLong elementProcessed) {
        this(step, containerName, workflowId, position, elementToProcess, elementProcessed);
        this.setId(id);
    }

    public ProcessStep(Step step, String containerName, String workflowId, int position, AtomicLong elementToProcess, AtomicLong elementProcessed) {
        ParametersChecker.checkParameter((String)"containerName could not be null", (String[])new String[]{containerName});
        ParametersChecker.checkParameter((String)"workflowId could not be null", (String[])new String[]{workflowId});
        ParametersChecker.checkParameter((String)"position could not be null", (Object[])new Object[]{position});
        ParametersChecker.checkParameter((String)"Step could not be null", (Object[])new Object[]{step});
        this.setId(step.getId());
        this.setActions(step.getActions());
        this.setDistribution(step.getDistribution());
        this.setStepName(step.getStepName());
        this.setBehavior(step.getBehavior());
        this.setWorkerGroupId(step.getWorkerGroupId());
        this.setWaitFor(step.getWaitFor());
        this.elementProcessed = elementProcessed;
        this.elementToProcess = elementToProcess;
    }

    ProcessStep() {
    }

    @JsonIgnore
    public boolean isBlockingKO() {
        return this.isBlocking() && StatusCode.KO.equals((Object)this.getStepStatusCode());
    }

    @VisibleForTesting
    public AtomicLong getElementProcessed() {
        return this.elementProcessed;
    }

    public ProcessStep setElementProcessed(AtomicLong elementProcessed) {
        this.elementProcessed = elementProcessed;
        return this;
    }

    @VisibleForTesting
    public AtomicLong getElementToProcess() {
        return this.elementToProcess;
    }

    public ProcessStep setElementToProcess(AtomicLong elementToProcess) {
        this.elementToProcess = elementToProcess;
        return this;
    }

    public StatusCode getStepStatusCode() {
        return this.stepStatusCode;
    }

    public ProcessStep setStepStatusCode(StatusCode stepStatusCode) {
        this.stepStatusCode = stepStatusCode;
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof ProcessStep) {
            ProcessStep processStep = (ProcessStep)((Object)object);
            return this.getId().equals(processStep.getId()) && this.getStepName().equals(processStep.getStepName()) && this.getWorkerGroupId().equals(processStep.getWorkerGroupId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getStepName(), this.getWorkerGroupId());
    }

    public String toString() {
        return this.getStepName() + " " + this.getActions() + " " + this.getDistribution().getKind() + " " + this.getDistribution().getElement() + " " + this.getId();
    }

    public void setLastStep(boolean lastStep) {
        this.lastStep = lastStep;
    }

    public boolean getLastStep() {
        return this.lastStep;
    }
}

