/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.model;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.model.EngineResponse;
import fr.gouv.vitam.processing.common.model.OutcomeMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProcessResponse
implements EngineResponse {
    private String processId;
    private StatusCode status;
    private Map<String, OutcomeMessage> outcomeMessages;
    private Integer numberErrors;
    private String messageId;
    private Map<String, List<EngineResponse>> stepResponses;

    @Override
    public StatusCode getStatus() {
        if (this.status == null) {
            return StatusCode.WARNING;
        }
        return this.status;
    }

    @Override
    public ProcessResponse setStatus(StatusCode status) {
        this.status = status;
        return this;
    }

    @Override
    public Map<String, OutcomeMessage> getOutcomeMessages() {
        if (this.outcomeMessages == null) {
            return Collections.emptyMap();
        }
        return this.outcomeMessages;
    }

    @Override
    public ProcessResponse setOutcomeMessages(String handlerId, OutcomeMessage message) {
        ParametersChecker.checkParameter((String)"Handler id is a mandatory parameter", (String[])new String[]{handlerId});
        ParametersChecker.checkParameter((String)"Outcome Detail Message is a mandatory parameter", (Object[])new Object[]{message});
        if (this.outcomeMessages == null) {
            this.outcomeMessages = new HashMap<String, OutcomeMessage>();
        }
        this.outcomeMessages.put(handlerId, message);
        return this;
    }

    public Map<String, List<EngineResponse>> getStepResponses() {
        if (this.stepResponses == null) {
            return Collections.emptyMap();
        }
        return this.stepResponses;
    }

    public ProcessResponse setStepResponses(Map<String, List<EngineResponse>> stepResponses) {
        if (stepResponses != null && !stepResponses.isEmpty()) {
            stepResponses.forEach((actionKey, responses) -> {
                this.status = this.getGlobalProcessStatusCode((List<EngineResponse>)responses);
            });
        }
        this.stepResponses = stepResponses;
        return this;
    }

    public StatusCode getGlobalProcessStatusCode(List<EngineResponse> responses) {
        StatusCode statusCode = StatusCode.OK;
        if (responses != null) {
            for (EngineResponse response : responses) {
                if (StatusCode.FATAL == response.getStatus()) {
                    statusCode = StatusCode.FATAL;
                    break;
                }
                if (StatusCode.KO == response.getStatus()) {
                    statusCode = StatusCode.KO;
                    continue;
                }
                if (StatusCode.WARNING != response.getStatus() || this.status == StatusCode.KO) continue;
                statusCode = StatusCode.WARNING;
            }
        }
        return statusCode;
    }

    public static String getGlobalProcessOutcomeMessage(List<EngineResponse> responses) {
        StringBuilder globalOutcomeMessage = new StringBuilder();
        LinkedHashMap<String, Integer> histogramResponse = new LinkedHashMap<String, Integer>();
        if (responses != null) {
            int totalStepError = responses.stream().mapToInt(EngineResponse::getErrorNumber).sum();
            for (EngineResponse engineResponse : responses) {
                for (Map.Entry<String, OutcomeMessage> entry : engineResponse.getOutcomeMessages().entrySet()) {
                    String key = entry.getKey() + " " + engineResponse.getStatus();
                    Integer nb = (Integer)histogramResponse.get(key);
                    if (nb == null) {
                        histogramResponse.put(key, 1);
                        continue;
                    }
                    histogramResponse.put(key, nb + 1);
                }
            }
            for (Map.Entry entry : histogramResponse.entrySet()) {
                globalOutcomeMessage.append((String)entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
            }
            if (totalStepError > 0) {
                globalOutcomeMessage.append(". Nombre total d'erreurs : ").append(totalStepError);
            }
        }
        if (globalOutcomeMessage.length() == 0) {
            globalOutcomeMessage.append("DefaultMessage");
        }
        return globalOutcomeMessage.toString();
    }

    public static String getMessageIdentifierFromResponse(List<EngineResponse> responses) {
        String messageId = "";
        if (responses != null) {
            for (EngineResponse response : responses) {
                if (response.getMessageIdentifier().isEmpty()) continue;
                messageId = response.getMessageIdentifier();
            }
        }
        return messageId;
    }

    @Override
    public String getValue() {
        if (this.status == null) {
            return StatusCode.FATAL.name();
        }
        return this.status.name();
    }

    @Override
    public String getMessageIdentifier() {
        if (this.messageId == null) {
            return "";
        }
        return this.messageId;
    }

    @Override
    public EngineResponse setMessageIdentifier(String message) {
        if (message != null) {
            this.messageId = message;
        }
        return this;
    }

    @Override
    public int getErrorNumber() {
        if (this.numberErrors == null) {
            return 0;
        }
        return this.numberErrors;
    }

    @Override
    public EngineResponse setErrorNumber(int number) {
        ParametersChecker.checkParameter((String)"Detail message is a mandatory parameter", (Object[])new Object[]{number});
        this.numberErrors = number;
        return this;
    }

    public String getProcessId() {
        return this.processId;
    }

    public ProcessResponse setProcessId(String processId) {
        this.processId = processId;
        return this;
    }
}

