/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.metrics;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public class CommonProcessingMetrics {
    public static final Gauge WORKER_TASKS_IN_QUEUE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("vitam_processing_worker_task_in_queue_total")).labelNames(new String[]{"worker_family"})).help("Current number of worker tasks in the queue")).register();
    public static final Gauge CURRENTLY_INSTANTIATED_TASKS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("vitam_processing_worker_current_task_total")).labelNames(new String[]{"worker_family", "workflow", "step_name"})).help("Current number of worker tasks instantiated by the distributor. In queue or waiting to be added to the queue")).register();
    public static final Gauge REGISTERED_WORKERS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("vitam_processing_worker_registered_total")).labelNames(new String[]{"worker_family"})).help("Current number of workers")).register();
    public static final Histogram WORKER_TASKS_EXECUTION_DURATION_HISTOGRAM = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("vitam_processing_worker_task_execution_duration_seconds")).help("Worker tasks execution duration. From call of worker until receiving the response. Task contains one or collection of elements to send to workers")).labelNames(new String[]{"worker_family", "worker_name", "workflow", "step_name"})).buckets(new double[]{0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 30.0, 60.0, 120.0, 180.0, 300.0, 600.0, 1800.0, 3600.0}).register();
    public static final Histogram WORKER_TASKS_IDLE_DURATION_IN_QUEUE = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("vitam_processing_worker_task_idle_duration_in_queue_seconds")).help("Worker tasks waiting time since task creation until task dequeue from the queue. Task contains one or collection of elements to send to workers")).labelNames(new String[]{"worker_family", "workflow", "step_name"})).buckets(new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 30.0, 60.0, 120.0, 180.0, 300.0, 600.0, 1800.0, 3600.0}).register();
    public static final Histogram PROCESS_WORKFLOW_STEP_EXECUTION_DURATION_HISTOGRAM = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("vitam_processing_workflow_step_execution_duration_seconds")).help("ProcessWorkflow step execution duration. From call of distributor until receiving the response")).labelNames(new String[]{"workflow", "step_name"})).buckets(new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 30.0, 60.0, 120.0, 180.0, 300.0, 600.0, 1800.0, 3600.0}).register();
}

