/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.util;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.scheduler.server.SchedulerConfiguration;
import fr.gouv.vitam.scheduler.server.SchedulerListener;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.quartz.SchedulerException;
import org.quartz.plugins.xml.XMLSchedulingDataProcessorPlugin;
import org.quartz.simpl.SimpleClassLoadHelper;
import org.quartz.spi.ClassLoadHelper;

public class VitamJobsDataProcessorPlugin {
    private static final String FILE_NAME_DELIMITERS = ",";
    private final String fileNames;
    XMLSchedulingDataProcessorPlugin dataProcessorPlugin = new XMLSchedulingDataProcessorPlugin();

    public VitamJobsDataProcessorPlugin(SchedulerConfiguration configuration) {
        this.fileNames = configuration.getFileNames();
        this.dataProcessorPlugin.setFailOnFileNotFound(configuration.isFailOnFileNotFound());
    }

    public void initialize() throws SchedulerException {
        String filesToLoad = this.refreshListFiles();
        this.dataProcessorPlugin.setFileNames(filesToLoad);
        this.dataProcessorPlugin.initialize("VitamJobs", SchedulerListener.getInstance().getScheduler(), (ClassLoadHelper)new SimpleClassLoadHelper());
        this.dataProcessorPlugin.start();
    }

    private String refreshListFiles() throws SchedulerException {
        WildcardFileFilter fileFilter;
        Path path = Path.of(VitamConfiguration.getVitamConfigFolder(), new String[0]).resolve(Path.of(this.fileNames, new String[0]));
        File dir = path.getParent().toFile();
        File[] files = dir.listFiles((FileFilter)(fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{path.getFileName().toString()}).get()));
        if (Objects.nonNull(files) && files.length != 0) {
            return Arrays.stream(files).map(File::getAbsolutePath).collect(Collectors.joining(FILE_NAME_DELIMITERS));
        }
        throw new SchedulerException("Cannot find job files");
    }
}

