/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job.auditobject;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.scheduler.server.job.auditobject.AuditPoller;
import fr.gouv.vitam.scheduler.server.job.auditobject.AuditWorkflowLauncher;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Stream;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class AuditObjectJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditObjectJob.class);
    private static final int AUDIT_POOL_SIZE = 5;
    private static final Boolean EMPTY_RESULT_IS_SUCCESSFUL = Boolean.TRUE;
    private static final String AUDIT_TYPE_KEY = "auditType";
    private static final String OPERATIONS_DELAY_IN_MINUTES_KEY = "operationsDelayInMinutes";
    private static final String CHECK_INTEGRITY_ID = "AUDIT_FILE_INTEGRITY";
    private static final String CHECK_EXISTENCE_ID = "AUDIT_FILE_EXISTING";
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;

    @VisibleForTesting
    AuditObjectJob(AdminManagementClientFactory adminManagementClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, ProcessingManagementClientFactory processingManagementClientFactory, MetaDataClientFactory metaDataClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public AuditObjectJob() {
        this(AdminManagementClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance(), ProcessingManagementClientFactory.getInstance(), MetaDataClientFactory.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Integrity audit job in progress...");
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)5);
        try {
            CompletableFuture[] completableFutures = (CompletableFuture[])VitamConfiguration.getTenants().stream().map(tenantId -> this.launchWorkflowAndPoll(context, executorService, (Integer)tenantId)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(completableFutures).join();
            if (!this.hasAllJobsFinishedSuccessfully(completableFutures)) {
                throw new JobExecutionException("At least one tenant has integrity audit failed");
            }
        }
        finally {
            executorService.shutdown();
            LOGGER.info("Integrity audit job is finished");
        }
    }

    private CompletableFuture<Optional<Boolean>> launchWorkflowAndPoll(JobExecutionContext context, ThreadPoolExecutor executorService, Integer tenantId) {
        AuditWorkflowLauncher auditWorkflowLauncher = new AuditWorkflowLauncher(this.adminManagementClientFactory, this.logbookOperationsClientFactory, this.processingManagementClientFactory, this.metaDataClientFactory);
        return CompletableFuture.supplyAsync(() -> {
            VitamThreadUtils.getVitamSession().setTenantId(tenantId);
            GUID operationId = GUIDFactory.newRequestIdGUID((int)tenantId);
            VitamThreadUtils.getVitamSession().setRequestId(operationId);
            JobDataMap jobDataMap = context.getMergedJobDataMap();
            int operationsDelayInMinutes = jobDataMap.getIntValue(OPERATIONS_DELAY_IN_MINUTES_KEY);
            String auditAction = this.getAuditAction(jobDataMap.getString(AUDIT_TYPE_KEY));
            return this.launchAndWait(auditWorkflowLauncher, tenantId, operationId.getId(), operationsDelayInMinutes, auditAction);
        }, executorService);
    }

    private Optional<Boolean> launchAndWait(AuditWorkflowLauncher auditWorkflowLauncher, Integer tenantId, String operationId, int operationsDelayInMinutes, String auditAction) {
        return auditWorkflowLauncher.launch(tenantId, operationId, operationsDelayInMinutes, auditAction).map(id -> new AuditPoller(this.processingManagementClientFactory, tenantId, (String)id)).map(AuditPoller::waitForTermination);
    }

    private boolean hasAllJobsFinishedSuccessfully(CompletableFuture<Optional<Boolean>>[] completableFutures) {
        return Stream.of(completableFutures).map(CompletableFuture::join).allMatch(value -> value.orElse(EMPTY_RESULT_IS_SUCCESSFUL));
    }

    private String getAuditAction(String auditType) {
        if (auditType == null) {
            throw new IllegalStateException("Audit type cannot be null");
        }
        if (auditType.equalsIgnoreCase("Integrity")) {
            return CHECK_INTEGRITY_ID;
        }
        if (auditType.equalsIgnoreCase("Existence")) {
            return CHECK_EXISTENCE_ID;
        }
        throw new IllegalStateException("Cannot find audit type = " + auditType);
    }
}

