/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job.auditobject;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.model.DatabaseCursor;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import java.time.LocalDateTime;
import java.util.Objects;

public class AuditMetadataFetcher {
    private static final long THRESHOLD = VitamConfiguration.getDistributionThreshold();
    private final MetaDataClientFactory metaDataClientFactory;

    public AuditMetadataFetcher(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public String getLastUpdateDateFromLastUnitToAudit(int operationsDelayInMinutes, String lastAuditData) {
        String string;
        block9: {
            MetaDataClient client = this.metaDataClientFactory.getClient();
            try {
                String scrollId;
                DatabaseCursor hits;
                SelectMultiQuery selectMultiQuery = this.buildFilterESQuery(operationsDelayInMinutes, lastAuditData);
                String lastUpdateDate = null;
                int size = 0;
                do {
                    JsonNode result = client.selectUnits((JsonNode)selectMultiQuery.getFinalSelect());
                    RequestResponseOK requestResponse = RequestResponseOK.getFromJsonNode((JsonNode)result, JsonNode.class);
                    hits = requestResponse.getHits();
                    scrollId = hits.getScrollId();
                    selectMultiQuery.setScrollFilter(scrollId, 60000, VitamConfiguration.getElasticSearchScrollLimit().intValue());
                    size = (int)((long)size + hits.getSize());
                    JsonNode last = (JsonNode)Iterables.getLast((Iterable)requestResponse.getResults(), null);
                    if (last == null) continue;
                    lastUpdateDate = last.get(VitamFieldsHelper.approximateUpdateDate()).asText();
                } while (hits.getSize() > 0L && hits.getSize() >= (long)VitamConfiguration.getElasticSearchScrollLimit().intValue() && (long)size < THRESHOLD);
                this.clearScrollWhenPagingHasNotFinished(scrollId, client);
                string = lastUpdateDate;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new VitamRuntimeException(e);
                }
            }
            client.close();
        }
        return string;
    }

    private void clearScrollWhenPagingHasNotFinished(String scrollId, MetaDataClient client) throws MetaDataClientServerException {
        if (Objects.nonNull(scrollId)) {
            client.clearESScrollFilter(scrollId);
        }
    }

    private SelectMultiQuery buildFilterESQuery(int operationsDelayInMinutes, String lastAuditData) throws InvalidCreateOperationException, InvalidParseOperationException {
        SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
        if (Objects.nonNull(lastAuditData)) {
            selectMultiQuery.addQueries(new Query[]{QueryHelper.gte((String)VitamFieldsHelper.approximateUpdateDate(), (String)lastAuditData)});
        }
        selectMultiQuery.addQueries(new Query[]{QueryHelper.lt((String)VitamFieldsHelper.approximateUpdateDate(), (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.now().minusMinutes(operationsDelayInMinutes)))});
        selectMultiQuery.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.approximateUpdateDate()});
        selectMultiQuery.addOrderByAscFilter(new String[]{VitamFieldsHelper.approximateUpdateDate()});
        String scrollId = "START";
        selectMultiQuery.setScrollFilter(scrollId, 60000, VitamConfiguration.getElasticSearchScrollLimit().intValue());
        return selectMultiQuery;
    }
}

