/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RuleManagementAuditJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RuleManagementAuditJob.class);
    private final AdminManagementClientFactory adminManagementClientFactory;

    public RuleManagementAuditJob(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public RuleManagementAuditJob() {
        this(AdminManagementClientFactory.getInstance());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        List tenants = VitamConfiguration.getTenants();
        Integer adminTenant = VitamConfiguration.getAdminTenant();
        VitamThreadUtils.getVitamSession().setTenantId(adminTenant);
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)adminTenant));
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            LOGGER.info("Start rule audit");
            client.launchRuleAudit(tenants);
            LOGGER.info("Rule audit proceeded successfully");
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException e) {
            throw new JobExecutionException(" Error when auditing rules", e);
        }
    }
}

