/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class OfferLogCompactionJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OfferLogCompactionJob.class);
    private static final Integer TENANT_ID = VitamConfiguration.getAdminTenant();
    private static final String OFFER_STORAGE_ID = "offer_storage_id";
    private final StorageClientFactory storageClientFactory;

    public OfferLogCompactionJob() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public OfferLogCompactionJob(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        try (StorageClient client = this.storageClientFactory.getClient();){
            String offerId = jobDataMap.get((Object)OFFER_STORAGE_ID).toString();
            LOGGER.info("Process of OfferLogCompaction in progress for offer " + offerId);
            VitamContext vitamContext = new VitamContext(TENANT_ID);
            client.launchOfferLogCompaction(vitamContext, offerId);
            LOGGER.info("End of Process OfferLogCompaction for offer " + offerId);
        }
        catch (StorageServerClientException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

