/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server;

import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.scheduler.server.AdminSchedulerResource;
import fr.gouv.vitam.scheduler.server.SchedulerConfiguration;
import fr.gouv.vitam.scheduler.server.util.VitamJobsDataProcessorPlugin;
import fr.gouv.vitam.security.internal.filter.BasicAuthenticationFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;

public class SchedulerAdminApplication
extends AdminApplication {
    public SchedulerAdminApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            SchedulerConfiguration configuration = (SchedulerConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, SchedulerConfiguration.class));
            VitamJobsDataProcessorPlugin jobsDataProcessorPlugin = new VitamJobsDataProcessorPlugin(configuration);
            super.getSingletons().add(new BasicAuthenticationFilter((DefaultVitamApplicationConfiguration)configuration));
            super.getSingletons().add(new JsonParseExceptionMapper());
            super.getSingletons().add(new AdminSchedulerResource(jobsDataProcessorPlugin));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

