/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request.single;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.AbstractRequest;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class RequestSingle
extends AbstractRequest {
    protected Query query;

    public final RequestSingle resetQuery() {
        if (this.query != null) {
            this.query.clean();
        }
        return this;
    }

    @Override
    public RequestSingle reset() {
        this.resetFilter();
        this.resetQuery();
        return this;
    }

    @Override
    public final RequestSingle setQuery(Query query) throws InvalidCreateOperationException {
        ParametersChecker.checkParameter((String)"Query is a mandatory parameter", (Object[])new Object[]{query});
        if (query == null) {
            throw new InvalidCreateOperationException("Null Query");
        }
        if (!query.isReady()) {
            throw new InvalidCreateOperationException("Query is not ready to be set: " + query.getCurrentQuery());
        }
        this.query = query;
        return this;
    }

    @Override
    protected final ObjectNode getFinal() {
        ObjectNode node = JsonHandler.createObjectNode();
        if (this.query != null) {
            node.set(BuilderToken.GLOBAL.QUERY.exactToken(), (JsonNode)this.query.getCurrentQuery());
        } else {
            node.putObject(BuilderToken.GLOBAL.QUERY.exactToken());
        }
        if (this.filter != null && this.filter.size() > 0) {
            node.set(BuilderToken.GLOBAL.FILTER.exactToken(), (JsonNode)this.filter);
        } else {
            node.putObject(BuilderToken.GLOBAL.FILTER.exactToken());
        }
        return node;
    }

    public final Query getQuery() {
        return this.query;
    }

    @Override
    public final int getNbQueries() {
        return 1;
    }

    @Override
    public List<Query> getQueries() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(this.query);
        return queries;
    }

    @Override
    public Set<String> getRoots() {
        return Collections.emptySet();
    }

    @Override
    public JsonNode getData() {
        return JsonHandler.createObjectNode();
    }

    @Override
    public boolean getAllProjection() {
        return this.selectGetAllProjection();
    }

    @Override
    public ObjectNode getProjection() {
        return this.selectGetProjection();
    }

    @Override
    public List<Action> getActions() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        return "Requests: " + (this.query != null ? this.query : "") + super.toString();
    }

    public ArrayNode getDatas() {
        return JsonHandler.createArrayNode();
    }
}

