/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.List;
import java.util.Set;

public abstract class AbstractRequest {
    protected ObjectNode filter;
    protected ObjectNode projection;

    public final AbstractRequest resetHintFilter() {
        if (this.filter != null) {
            this.filter.remove(BuilderToken.SELECTFILTER.HINT.exactToken());
        }
        return this;
    }

    public final AbstractRequest resetFilter() {
        if (this.filter != null) {
            this.filter.removeAll();
        }
        return this;
    }

    public AbstractRequest reset() {
        this.resetFilter();
        return this;
    }

    public final AbstractRequest addHintFilter(String ... hints) throws InvalidParseOperationException {
        ArrayNode array;
        ParametersChecker.checkParameter((String)"Hint filter is a mandatory parameter", (String[])hints);
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        if ((array = (ArrayNode)this.filter.get(BuilderToken.SELECTFILTER.HINT.exactToken())) == null || array.isMissingNode()) {
            array = this.filter.putArray(BuilderToken.SELECTFILTER.HINT.exactToken());
        }
        for (String hint : hints) {
            GlobalDatas.sanityParameterCheck(hint);
            if (hint == null || hint.trim().isEmpty()) continue;
            array.add(hint.trim());
        }
        return this;
    }

    public final AbstractRequest addHintFilter(JsonNode filterContent) {
        ParametersChecker.checkParameter((String)"Filter Content is a mandatory parameter", (Object[])new Object[]{filterContent});
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        if (filterContent.has(BuilderToken.SELECTFILTER.HINT.exactToken())) {
            JsonNode node = filterContent.get(BuilderToken.SELECTFILTER.HINT.exactToken());
            if (node.isArray()) {
                this.filter.putArray(BuilderToken.SELECTFILTER.HINT.exactToken()).addAll((ArrayNode)node);
            } else {
                this.filter.putArray(BuilderToken.SELECTFILTER.HINT.exactToken()).add(node.asText());
            }
        }
        return this;
    }

    public AbstractRequest setFilter(JsonNode filterContent) throws InvalidParseOperationException {
        this.resetFilter();
        return this.addHintFilter(filterContent);
    }

    public final AbstractRequest parseFilter(String filter) throws InvalidParseOperationException {
        GlobalDatas.sanityParametersCheck(filter, 10);
        JsonNode filterContent = JsonHandler.getFromString((String)filter);
        return this.setFilter(filterContent);
    }

    public final ObjectNode getFilter() {
        if (this.filter == null) {
            return JsonHandler.createObjectNode();
        }
        return this.filter;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\tFilter: ").append(this.filter);
        return builder.toString();
    }

    public abstract AbstractRequest setQuery(Query var1) throws InvalidCreateOperationException;

    public abstract int getNbQueries();

    public abstract List<Query> getQueries();

    public abstract Set<String> getRoots();

    public abstract JsonNode getData();

    public abstract List<Action> getActions();

    public abstract boolean getAllProjection();

    public abstract ObjectNode getProjection();

    protected final AbstractRequest selectResetLimitFilter() {
        if (this.filter != null) {
            this.filter.remove(BuilderToken.SELECTFILTER.OFFSET.exactToken());
            this.filter.remove(BuilderToken.SELECTFILTER.LIMIT.exactToken());
        }
        return this;
    }

    protected final AbstractRequest selectResetOrderByFilter() {
        if (this.filter != null) {
            this.filter.remove(BuilderToken.SELECTFILTER.ORDERBY.exactToken());
        }
        return this;
    }

    protected final AbstractRequest selectResetUsedProjection() {
        if (this.projection != null) {
            this.projection.remove(BuilderToken.PROJECTION.FIELDS.exactToken());
        }
        return this;
    }

    protected final AbstractRequest selectReset() {
        this.selectResetUsedProjection();
        return this;
    }

    protected final AbstractRequest selectSetScrollFilter(String scrollId, int scrollTimeout, int limit) {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        this.selectResetLimitFilter();
        if (scrollId != null && !scrollId.isEmpty()) {
            this.filter.put(BuilderToken.SELECTFILTER.SCROLL_ID.exactToken(), scrollId);
        }
        if (limit > 0) {
            this.filter.put(BuilderToken.SELECTFILTER.LIMIT.exactToken(), limit);
        }
        if (scrollTimeout > 0) {
            this.filter.put(BuilderToken.SELECTFILTER.SCROLL_TIMEOUT.exactToken(), scrollTimeout);
        }
        return this;
    }

    protected final AbstractRequest selectSetLimitFilter(long offset, long limit) {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        this.selectResetLimitFilter();
        if (offset > 0L) {
            this.filter.put(BuilderToken.SELECTFILTER.OFFSET.exactToken(), offset);
        }
        if (limit > 0L) {
            this.filter.put(BuilderToken.SELECTFILTER.LIMIT.exactToken(), limit);
        }
        return this;
    }

    protected final AbstractRequest selectSetLimitFilter(JsonNode filterContent) {
        long offset = 0L;
        int limit = 10000;
        String scrollId = null;
        int timeout = 0;
        if (filterContent.has(BuilderToken.SELECTFILTER.LIMIT.exactToken())) {
            limit = filterContent.get(BuilderToken.SELECTFILTER.LIMIT.exactToken()).asInt(10000);
        }
        if (filterContent.has(BuilderToken.SELECTFILTER.OFFSET.exactToken())) {
            offset = filterContent.get(BuilderToken.SELECTFILTER.OFFSET.exactToken()).asLong(0L);
        }
        if (filterContent.has(BuilderToken.SELECTFILTER.SCROLL_ID.exactToken())) {
            scrollId = filterContent.get(BuilderToken.SELECTFILTER.SCROLL_ID.exactToken()).asText();
            if (filterContent.has(BuilderToken.SELECTFILTER.SCROLL_TIMEOUT.exactToken())) {
                timeout = filterContent.get(BuilderToken.SELECTFILTER.SCROLL_TIMEOUT.exactToken()).asInt(0);
            }
            this.selectSetScrollFilter(scrollId, timeout, limit);
        }
        return this.selectSetLimitFilter(offset, limit);
    }

    protected final AbstractRequest selectParseLimitFilter(String filter) throws InvalidParseOperationException {
        GlobalDatas.sanityParametersCheck(filter, 10);
        JsonNode rootNode = JsonHandler.getFromString((String)filter);
        return this.selectSetLimitFilter(rootNode);
    }

    protected final AbstractRequest selectAddOrderByAscFilter(String ... variableNames) throws InvalidParseOperationException {
        return this.addOrderByFilter(1, variableNames);
    }

    protected final AbstractRequest selectAddOrderByDescFilter(String ... variableNames) throws InvalidParseOperationException {
        return this.addOrderByFilter(-1, variableNames);
    }

    private final AbstractRequest addOrderByFilter(int way, String ... variableNames) throws InvalidParseOperationException {
        ObjectNode node;
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        if ((node = (ObjectNode)this.filter.get(BuilderToken.SELECTFILTER.ORDERBY.exactToken())) == null || node.isMissingNode()) {
            node = this.filter.putObject(BuilderToken.SELECTFILTER.ORDERBY.exactToken());
        }
        for (String var : variableNames) {
            if (var == null || var.trim().isEmpty()) continue;
            GlobalDatas.sanityParameterCheck(var);
            node.put(var.trim(), way);
        }
        return this;
    }

    protected final AbstractRequest selectAddOrderByFilter(JsonNode filterContent) throws InvalidParseOperationException {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        if (filterContent.has(BuilderToken.SELECTFILTER.ORDERBY.exactToken())) {
            JsonNode node = filterContent.get(BuilderToken.SELECTFILTER.ORDERBY.exactToken());
            this.filter.putObject(BuilderToken.SELECTFILTER.ORDERBY.exactToken()).setAll((ObjectNode)node);
        }
        return this;
    }

    protected final AbstractRequest selectParseOrderByFilter(String filter) throws InvalidParseOperationException {
        GlobalDatas.sanityParametersCheck(filter, 10);
        JsonNode rootNode = JsonHandler.getFromString((String)filter);
        return this.selectAddOrderByFilter(rootNode);
    }

    protected final AbstractRequest selectSetFilter(JsonNode filterContent) throws InvalidParseOperationException {
        return this.selectSetLimitFilter(filterContent).selectAddOrderByFilter(filterContent);
    }

    protected final AbstractRequest selectAddUsedProjection(String ... variableNames) throws InvalidParseOperationException {
        return this.addXxxProjection(1, variableNames);
    }

    protected final AbstractRequest selectAddUnusedProjection(String ... variableNames) throws InvalidParseOperationException {
        return this.addXxxProjection(0, variableNames);
    }

    private final AbstractRequest addXxxProjection(int way, String ... variableNames) throws InvalidParseOperationException {
        ObjectNode node;
        if (this.projection == null) {
            this.projection = JsonHandler.createObjectNode();
        }
        if ((node = (ObjectNode)this.projection.get(BuilderToken.PROJECTION.FIELDS.exactToken())) == null || node.isMissingNode()) {
            node = this.projection.putObject(BuilderToken.PROJECTION.FIELDS.exactToken());
        }
        for (String var : variableNames) {
            if (var == null || var.trim().isEmpty()) continue;
            GlobalDatas.sanityParameterCheck(var);
            node.put(var.trim(), way);
        }
        if (node.size() == 0) {
            this.projection.remove(BuilderToken.PROJECTION.FIELDS.exactToken());
        }
        return this;
    }

    protected final AbstractRequest selectAddProjection(JsonNode projectionContent) {
        if (this.projection == null) {
            this.projection = JsonHandler.createObjectNode();
        }
        if (projectionContent.has(BuilderToken.PROJECTION.FIELDS.exactToken())) {
            ObjectNode node = this.projection.putObject(BuilderToken.PROJECTION.FIELDS.exactToken());
            node.setAll((ObjectNode)projectionContent.get(BuilderToken.PROJECTION.FIELDS.exactToken()));
        }
        return this;
    }

    protected final AbstractRequest selectParseProjection(String projection) throws InvalidParseOperationException {
        GlobalDatas.sanityParametersCheck(projection, 1000);
        JsonNode rootNode = JsonHandler.getFromString((String)projection);
        return this.selectSetProjection(rootNode);
    }

    protected AbstractRequest selectSetProjection(JsonNode projectionContent) throws InvalidParseOperationException {
        this.selectResetUsedProjection();
        return this.selectAddProjection(projectionContent);
    }

    protected abstract ObjectNode getFinal();

    protected final ObjectNode selectGetFinalSelect() {
        ObjectNode node = this.getFinal();
        if (this.projection != null && this.projection.size() > 0) {
            node.set(BuilderToken.GLOBAL.PROJECTION.exactToken(), (JsonNode)this.projection);
        } else {
            node.putObject(BuilderToken.GLOBAL.PROJECTION.exactToken());
        }
        return node;
    }

    protected boolean selectGetAllProjection() {
        if (this.projection != null) {
            ObjectNode node = (ObjectNode)this.projection.get(BuilderToken.PROJECTION.FIELDS.exactToken());
            if (node == null || node.isMissingNode()) {
                return true;
            }
            String all = VitamFieldsHelper.all();
            if (node.has(all) && node.get(all).asInt() > 0) {
                return true;
            }
            return !node.fieldNames().hasNext();
        }
        return true;
    }

    protected ObjectNode selectGetProjection() {
        if (this.projection == null) {
            return JsonHandler.createObjectNode();
        }
        return this.projection;
    }
}

