/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SetAction
extends Action {
    private static final String CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME = " cannot be updated with empty variable name";
    private static final String CANNOT_ADD_A_SET_ELEMENT_SINCE_THIS_IS_NOT_A_SET_ACTION = "Cannot add a set element since this is not a Set Action: ";
    private static final String CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME2 = " cannot be created with empty variable name";
    private static final String ACTION = "Action ";

    protected SetAction() {
    }

    public SetAction(String variableName, String value) throws InvalidCreateOperationException {
        this.createActionVariableValue(BuilderToken.UPDATEACTION.SET, variableName, value);
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public SetAction(String variableName, List<?> value) throws InvalidCreateOperationException {
        this.createActionVariableValue(BuilderToken.UPDATEACTION.SET, variableName, value);
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public SetAction(Map<String, ?> variableNameValue) throws InvalidCreateOperationException {
        this.currentObject = ((ObjectNode)this.currentObject).putObject(BuilderToken.UPDATEACTION.SET.exactToken());
        ObjectNode node = (ObjectNode)this.currentObject;
        for (Map.Entry<String, ?> entry : variableNameValue.entrySet()) {
            String name = entry.getKey();
            if (name == null || name.trim().isEmpty()) continue;
            try {
                GlobalDatas.sanityParameterCheck(name);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            Object val = entry.getValue();
            node.set(name.trim(), GlobalDatas.getValueJsonNode(val));
        }
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public SetAction(ObjectNode updateData) throws InvalidCreateOperationException {
        this.currentObject = ((ObjectNode)this.currentObject).putObject(BuilderToken.UPDATEACTION.SET.exactToken());
        ObjectNode node = (ObjectNode)this.currentObject;
        Iterator iterator = updateData.fieldNames();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                GlobalDatas.sanityParameterCheck(key);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            node.set(key, updateData.get(key));
        }
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public SetAction(String variableName, long value) throws InvalidCreateOperationException {
        this.createActionVariableValue(BuilderToken.UPDATEACTION.SET, variableName, value);
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public SetAction(String variableName, boolean value) throws InvalidCreateOperationException {
        this.createActionVariableValue(BuilderToken.UPDATEACTION.SET, variableName, value);
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public SetAction(String variableName, double value) throws InvalidCreateOperationException {
        this.createActionVariableValue(BuilderToken.UPDATEACTION.SET, variableName, value);
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public SetAction(String variableName, Date value) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME2);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        this.currentObject = ((ObjectNode)this.currentObject).putObject(BuilderToken.UPDATEACTION.SET.exactToken());
        ObjectNode node = (ObjectNode)this.currentObject;
        node.set(variableName, (JsonNode)GlobalDatas.getDate(value));
        this.currentUPDATEACTION = BuilderToken.UPDATEACTION.SET;
        this.setReady(true);
    }

    public final SetAction add(String variableName, String value) throws InvalidCreateOperationException {
        if (this.currentUPDATEACTION != BuilderToken.UPDATEACTION.SET) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_SET_ELEMENT_SINCE_THIS_IS_NOT_A_SET_ACTION + this.currentUPDATEACTION);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
            GlobalDatas.sanityValueCheck(value);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final SetAction add(String variableName, boolean value) throws InvalidCreateOperationException {
        if (this.currentUPDATEACTION != BuilderToken.UPDATEACTION.SET) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_SET_ELEMENT_SINCE_THIS_IS_NOT_A_SET_ACTION + this.currentUPDATEACTION);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final SetAction add(String variableName, long value) throws InvalidCreateOperationException {
        if (this.currentUPDATEACTION != BuilderToken.UPDATEACTION.SET) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_SET_ELEMENT_SINCE_THIS_IS_NOT_A_SET_ACTION + this.currentUPDATEACTION);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final SetAction add(String variableName, double value) throws InvalidCreateOperationException {
        if (this.currentUPDATEACTION != BuilderToken.UPDATEACTION.SET) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_SET_ELEMENT_SINCE_THIS_IS_NOT_A_SET_ACTION + this.currentUPDATEACTION);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).put(variableName.trim(), value);
        return this;
    }

    public final SetAction add(String variableName, Date value) throws InvalidCreateOperationException {
        if (this.currentUPDATEACTION != BuilderToken.UPDATEACTION.SET) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_SET_ELEMENT_SINCE_THIS_IS_NOT_A_SET_ACTION + this.currentUPDATEACTION);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ((ObjectNode)this.currentObject).set(variableName, (JsonNode)GlobalDatas.getDate(value));
        return this;
    }

    public final SetAction add(String variableName, List<?> values) throws InvalidCreateOperationException {
        if (this.currentUPDATEACTION != BuilderToken.UPDATEACTION.SET) {
            throw new InvalidCreateOperationException(CANNOT_ADD_A_SET_ELEMENT_SINCE_THIS_IS_NOT_A_SET_ACTION + this.currentUPDATEACTION);
        }
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        if (values == null) {
            throw new InvalidCreateOperationException(ACTION + this.currentUPDATEACTION + " cannot update with null list");
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
            if (!values.isEmpty()) {
                GlobalDatas.sanityValueCheck(values);
            }
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        ArrayNode array = JsonHandler.createArrayNode();
        GlobalDatas.setArrayValueFromList(array, values);
        ((ObjectNode)this.currentObject).set(variableName.trim(), (JsonNode)array);
        return this;
    }
}

