/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.util.HashSet;
import java.util.Set;

public class MltQuery
extends Query {
    private static final String CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME = " cannot be created with empty variable name";
    private static final String QUERY2 = "Query ";
    protected Set<String> stringVals;

    protected MltQuery() {
    }

    @Override
    public void clean() {
        super.clean();
        if (this.stringVals != null) {
            this.stringVals.clear();
        }
        this.stringVals = null;
    }

    public MltQuery(BuilderToken.QUERY mltQuery, String value, String ... variableNames) throws InvalidCreateOperationException {
        if (value == null || value.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + mltQuery + CANNOT_BE_CREATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityValueCheck(value);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        switch (mltQuery) {
            case FLT: 
            case MLT: {
                ObjectNode sub = ((ObjectNode)this.currentObject).putObject(mltQuery.exactToken());
                ArrayNode array = sub.putArray(BuilderToken.QUERYARGS.FIELDS.exactToken());
                this.stringVals = new HashSet<String>();
                for (String varName : variableNames) {
                    if (varName == null || varName.trim().isEmpty()) continue;
                    try {
                        GlobalDatas.sanityParameterCheck(varName);
                    }
                    catch (InvalidParseOperationException e) {
                        throw new InvalidCreateOperationException(e);
                    }
                    String var = varName.trim();
                    if (this.stringVals.contains(var)) continue;
                    array.add(var);
                    this.stringVals.add(var);
                }
                this.currentObject = array;
                sub.put(BuilderToken.QUERYARGS.LIKE.exactToken(), value);
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + mltQuery + " is not an MoreLikeThis or In Query");
            }
        }
        this.currentTokenQUERY = mltQuery;
        this.setReady(true);
    }

    public final MltQuery add(String ... variableName) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != BuilderToken.QUERY.FLT && this.currentTokenQUERY != BuilderToken.QUERY.MLT) {
            throw new InvalidCreateOperationException("Cannot add a variableName since this is not an Mlt Query: " + this.currentTokenQUERY);
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        if (this.stringVals == null) {
            this.stringVals = new HashSet<String>();
        }
        for (String val : variableName) {
            if (val == null || val.trim().isEmpty()) {
                throw new InvalidCreateOperationException(QUERY2 + this.currentTokenQUERY + " cannot be updated with empty variable name");
            }
            try {
                GlobalDatas.sanityParameterCheck(val);
            }
            catch (InvalidParseOperationException e) {
                throw new InvalidCreateOperationException(e);
            }
            val = val.trim();
            if (this.stringVals.contains(val)) continue;
            array.add(val);
            this.stringVals.add(val);
        }
        return this;
    }
}

