/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.facet;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.facet.model.FacetOrder;
import fr.gouv.vitam.common.json.JsonHandler;

public class TermsFacet
extends Facet {
    public TermsFacet(String name, String field, String nestedPath, Integer size, FacetOrder order) throws InvalidCreateOperationException {
        super(name);
        this.populateFacet(name, field, nestedPath, size, order);
    }

    public TermsFacet(String name, String field, Integer size, FacetOrder order) throws InvalidCreateOperationException {
        super(name);
        this.populateFacet(name, field, null, size, order);
    }

    private void populateFacet(String name, String field, String nestedPath, Integer size, FacetOrder order) throws InvalidCreateOperationException {
        this.setName(name);
        this.currentTokenFACET = BuilderToken.FACET.TERMS;
        ObjectNode facetNode = JsonHandler.createObjectNode();
        facetNode.put(BuilderToken.FACETARGS.FIELD.exactToken(), field);
        if (nestedPath != null) {
            facetNode.put(BuilderToken.FACETARGS.SUBOBJECT.exactToken(), nestedPath);
        }
        this.currentFacet = facetNode;
        if (size == null || size <= 0) {
            throw new InvalidCreateOperationException("Size must be > 0 in Terms Facet");
        }
        this.currentFacet.put(BuilderToken.FACETARGS.SIZE.exactToken(), size);
        if (order == null) {
            throw new InvalidCreateOperationException("Order is mandatory in Terms Facet");
        }
        this.currentFacet.put(BuilderToken.FACETARGS.ORDER.exactToken(), order.name());
    }
}

