/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.service.migration;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.security.internal.common.model.CertificateStatus;
import org.bson.Document;

public class SecurityDataMigrationRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SecurityDataMigrationRepository.class);
    private final MongoCollection<Document> identityCertificateCollection;
    private final MongoCollection<Document> personalCertificateCollection;

    public SecurityDataMigrationRepository(MongoDbAccess mongoDbAccess) {
        this.identityCertificateCollection = mongoDbAccess.getMongoDatabase().getCollection("Certificate");
        this.personalCertificateCollection = mongoDbAccess.getMongoDatabase().getCollection("PersonalCertificate");
    }

    public void migrateCertificatesData(CertificateStatus certificateStatus) {
        this.addCertificateStateField(this.identityCertificateCollection, certificateStatus);
        this.addCertificateStateField(this.personalCertificateCollection, certificateStatus);
    }

    private void addCertificateStateField(MongoCollection<Document> certificateMongoCollection, CertificateStatus certificateStatus) {
        LOGGER.info("About to migrate certificates for {} collection", (Object)certificateMongoCollection.getNamespace().getFullName());
        certificateMongoCollection.updateMany(Filters.exists((String)"Status", (boolean)false), Updates.set((String)"Status", (Object)certificateStatus.name()));
        LOGGER.info("Certificate's record successfully migrated for {} collection", (Object)certificateMongoCollection.getNamespace().getFullName());
    }
}

