/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.service;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.security.internal.common.model.CertificateBaseModel;
import fr.gouv.vitam.security.internal.rest.repository.CertificateRepository;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.List;

public abstract class SecurityService {
    private final AlertService alertService;

    public SecurityService() {
        this((AlertService)new AlertServiceImpl());
    }

    public SecurityService(AlertService alertService) {
        this.alertService = alertService;
    }

    public void checkCertificates() throws InvalidParseOperationException, ParseException {
        List<? extends CertificateBaseModel> all = this.getRepository().findAll();
        for (CertificateBaseModel certificateBaseModel : all) {
            LocalDateTime expirationDate = LocalDateUtil.fromDate((Date)LocalDateUtil.getDate((String)certificateBaseModel.getExpirationDate()));
            if (expirationDate.isBefore(LocalDateUtil.now().toLocalDate().atStartOfDay())) {
                this.alertService.createAlert(VitamLogLevel.WARN, "A certificate with SubjectDN = " + certificateBaseModel.getSubjectDN() + " is expired on " + expirationDate.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.SHORT)));
                continue;
            }
            if (!expirationDate.isBefore(LocalDateUtil.now().plus(Period.ofMonths(6)).toLocalDate().atStartOfDay())) continue;
            this.alertService.createAlert(VitamLogLevel.WARN, "A certificate with SubjectDN = " + certificateBaseModel.getSubjectDN() + " will be expired on " + expirationDate.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.SHORT)));
        }
    }

    abstract CertificateRepository getRepository();
}

