/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.service;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.security.internal.common.model.IsPersonalCertificateRequiredModel;
import fr.gouv.vitam.security.internal.rest.server.PersonalCertificatePermissionConfig;

public class PermissionService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PermissionService.class);
    private final PersonalCertificatePermissionConfig personalCertificatePermissionConfig;

    public PermissionService(PersonalCertificatePermissionConfig personalCertificatePermissionConfig) {
        this.personalCertificatePermissionConfig = personalCertificatePermissionConfig;
    }

    public IsPersonalCertificateRequiredModel isPersonalCertificateRequiredForPermission(String permission) {
        if (this.personalCertificatePermissionConfig.getPermissionsRequiringPersonalCertificate() != null && this.personalCertificatePermissionConfig.getPermissionsRequiringPersonalCertificate().contains(permission)) {
            LOGGER.debug("Required personal certificate for permission {}", (Object)permission);
            return new IsPersonalCertificateRequiredModel(IsPersonalCertificateRequiredModel.Response.REQUIRED_PERSONAL_CERTIFICATE);
        }
        if (this.personalCertificatePermissionConfig.getPermissionsWithoutPersonalCertificate() != null && this.personalCertificatePermissionConfig.getPermissionsWithoutPersonalCertificate().contains(permission)) {
            LOGGER.debug("Non required personal certificate for permission {}", (Object)permission);
            return new IsPersonalCertificateRequiredModel(IsPersonalCertificateRequiredModel.Response.IGNORED_PERSONAL_CERTIFICATE);
        }
        LOGGER.error("Unknown permission {}", (Object)permission);
        return new IsPersonalCertificateRequiredModel(IsPersonalCertificateRequiredModel.Response.ERROR_UNKNOWN_PERMISSION);
    }
}

