/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.security.internal.common.exception.PersonalCertificateException;
import fr.gouv.vitam.security.internal.common.model.IsPersonalCertificateRequiredModel;
import fr.gouv.vitam.security.internal.rest.service.PermissionService;
import fr.gouv.vitam.security.internal.rest.service.PersonalCertificateService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.text.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/api/personalCertificate")
@Tag(name="Security")
public class PersonalCertificateResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PersonalCertificateResource.class);
    private final PermissionService permissionService;
    private final PersonalCertificateService personalCertificateService;

    public PersonalCertificateResource(PermissionService permissionService, PersonalCertificateService personalCertificateService) {
        this.permissionService = permissionService;
        this.personalCertificateService = personalCertificateService;
    }

    @Path(value="/personal-certificate-check/{permission}")
    @GET
    @Consumes(value={"application/octet-stream"})
    public void checkPersonalCertificate(byte[] certificate, @PathParam(value="permission") String permission) throws LogbookClientException, InvalidParseOperationException, PersonalCertificateException {
        ParametersChecker.checkParameter((String)"Permission cannot be null", (String[])new String[]{permission});
        this.personalCertificateService.checkPersonalCertificateExistence(certificate, permission);
    }

    @GET
    @Path(value="/permission-check/{permission}")
    @Produces(value={"application/json"})
    public IsPersonalCertificateRequiredModel isPersonalCertificateRequiredForPermission(@PathParam(value="permission") String permission) {
        ParametersChecker.checkParameter((String)"Permission cannot be null", (String[])new String[]{permission});
        return this.permissionService.isPersonalCertificateRequiredForPermission(permission);
    }

    @GET
    @Path(value="/check-expiration")
    @Produces(value={"application/json"})
    public Response checkCertificatesExpiration() {
        try {
            this.personalCertificateService.checkCertificates();
        }
        catch (InvalidParseOperationException | ParseException e) {
            LOGGER.error("cannot check certificate expiration date", e);
            return Response.serverError().build();
        }
        return Response.accepted().build();
    }
}

