/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.security.internal.common.exception.PersonalCertificateException;
import fr.gouv.vitam.security.internal.rest.service.PersonalCertificateService;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

@Path(value="/v1/api/personalCertificate")
@Tag(name="Security")
public class AdminPersonalCertificateResource {
    private final PersonalCertificateService personalCertificateService;

    public AdminPersonalCertificateResource(PersonalCertificateService personalCertificateService) {
        this.personalCertificateService = personalCertificateService;
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    public void createIfNotPresent(byte[] certificate) throws PersonalCertificateException, InvalidParseOperationException {
        ParametersChecker.checkParameter((String)"Certificate cannot be null", (Object[])new Object[]{certificate});
        this.personalCertificateService.createPersonalCertificateIfNotPresent(certificate);
    }

    @DELETE
    @Consumes(value={"application/octet-stream"})
    public void delete(byte[] certificate) throws PersonalCertificateException {
        ParametersChecker.checkParameter((String)"Certificate cannot be null", (Object[])new Object[]{certificate});
        this.personalCertificateService.deletePersonalCertificateIfPresent(certificate);
    }
}

