/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.security.internal.common.service.CRLService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

@Path(value="/v1/api/crl")
@Tag(name="Security")
public class AdminCRLResource {
    private final CRLService crlService;

    public AdminCRLResource(CRLService crlService) {
        this.crlService = crlService;
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    public void checkIdentityWithCRL(byte[] crlCertificate) throws InvalidParseOperationException, CertificateException, CRLException {
        ParametersChecker.checkParameter((String)"CRL certificate cannot be null", (Object[])new Object[]{crlCertificate});
        this.crlService.checkIdentityWithCRL(crlCertificate);
    }
}

