/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.result.DeleteResult;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.security.internal.common.model.CertificateStatus;
import fr.gouv.vitam.security.internal.common.model.PersonalCertificateModel;
import fr.gouv.vitam.security.internal.rest.repository.CertificateCRLCheckRepositoryHelper;
import fr.gouv.vitam.security.internal.rest.repository.CertificateCRLCheckStateUpdater;
import fr.gouv.vitam.security.internal.rest.repository.CertificateRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PersonalRepository
implements CertificateRepository,
CertificateCRLCheckStateUpdater<PersonalCertificateModel> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PersonalRepository.class);
    public static final String PERSONAL_COLLECTION = "PersonalCertificate";
    private final MongoCollection<Document> personnalCollection;
    private final CertificateCRLCheckRepositoryHelper crlRepositoryHelper;

    @VisibleForTesting
    public PersonalRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.personnalCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
        this.crlRepositoryHelper = new CertificateCRLCheckRepositoryHelper(this.personnalCollection);
    }

    public PersonalRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, PERSONAL_COLLECTION);
    }

    public void createPersonalCertificate(PersonalCertificateModel personalCertificateModel) throws InvalidParseOperationException {
        String json = JsonHandler.writeAsString((Object)personalCertificateModel);
        this.personnalCollection.insertOne((Object)Document.parse((String)json));
    }

    public Optional<PersonalCertificateModel> findPersonalCertificateByHash(String hash) throws InvalidParseOperationException {
        FindIterable models = this.personnalCollection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"Hash", (Object)hash), Filters.eq((String)"Status", (Object)CertificateStatus.VALID.name())}));
        Document first = (Document)models.first();
        if (first == null) {
            return Optional.empty();
        }
        return Optional.of((PersonalCertificateModel)BsonHelper.fromDocumentToObject((Document)first, PersonalCertificateModel.class));
    }

    public List<PersonalCertificateModel> findAll() throws InvalidParseOperationException {
        ArrayList<PersonalCertificateModel> result = new ArrayList<PersonalCertificateModel>();
        FindIterable models = this.personnalCollection.find().projection(Projections.exclude((String[])new String[]{"Certificate"}));
        for (Document model : models) {
            result.add((PersonalCertificateModel)BsonHelper.fromDocumentToObject((Document)model, PersonalCertificateModel.class));
        }
        return result;
    }

    public void deletePersonalCertificate(String hash) {
        DeleteResult deleteResult = this.personnalCollection.deleteOne(Filters.eq((String)"Hash", (Object)hash));
        LOGGER.debug("Deleted document count: " + deleteResult.getDeletedCount());
    }

    @Override
    public FindIterable<Document> findCertificate(String issuerDN, CertificateStatus certificateStatus) throws InvalidParseOperationException {
        return this.crlRepositoryHelper.findCertificate(issuerDN, certificateStatus);
    }

    @Override
    public void updateCertificateState(List<String> certificatesToUpdate, CertificateStatus certificateStatus) {
        this.crlRepositoryHelper.updateCertificateState(certificatesToUpdate, certificateStatus);
    }

    @Override
    public Class<PersonalCertificateModel> getEntityModelType() {
        return PersonalCertificateModel.class;
    }
}

