/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Updates;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.security.internal.common.model.CertificateStatus;
import fr.gouv.vitam.security.internal.common.model.IdentityModel;
import fr.gouv.vitam.security.internal.rest.repository.CertificateCRLCheckRepositoryHelper;
import fr.gouv.vitam.security.internal.rest.repository.CertificateCRLCheckStateUpdater;
import fr.gouv.vitam.security.internal.rest.repository.CertificateRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;

public class IdentityRepository
implements CertificateRepository,
CertificateCRLCheckStateUpdater<IdentityModel> {
    public static final String CERTIFICATE_COLLECTION = "Certificate";
    private final MongoCollection<Document> identityCollection;
    private final CertificateCRLCheckRepositoryHelper crlRepositoryHelper;

    @VisibleForTesting
    public IdentityRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.identityCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
        this.crlRepositoryHelper = new CertificateCRLCheckRepositoryHelper(this.identityCollection);
    }

    public IdentityRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, CERTIFICATE_COLLECTION);
    }

    public void createIdentity(IdentityModel identityModel) throws InvalidParseOperationException {
        String json = JsonHandler.writeAsString((Object)identityModel);
        this.identityCollection.insertOne((Object)Document.parse((String)json));
    }

    public Optional<IdentityModel> findIdentity(String subjectDN, String serialNumber) throws InvalidParseOperationException {
        FindIterable models = this.identityCollection.find(this.filterBySubjectDNAndSerialNumber(subjectDN, serialNumber));
        Document first = (Document)models.first();
        if (first == null) {
            return Optional.empty();
        }
        return Optional.of((IdentityModel)BsonHelper.fromDocumentToObject((Document)first, IdentityModel.class));
    }

    public List<IdentityModel> findAll() throws InvalidParseOperationException {
        ArrayList<IdentityModel> result = new ArrayList<IdentityModel>();
        FindIterable models = this.identityCollection.find().projection(Projections.exclude((String[])new String[]{CERTIFICATE_COLLECTION}));
        for (Document model : models) {
            result.add((IdentityModel)BsonHelper.fromDocumentToObject((Document)model, IdentityModel.class));
        }
        return result;
    }

    public void linkContextToIdentity(String subjectDN, String contextId, String serialNumber) {
        this.identityCollection.updateOne(this.filterBySubjectDNAndSerialNumber(subjectDN, serialNumber), Updates.set((String)"ContextId", (Object)contextId));
    }

    private Bson filterBySubjectDNAndSerialNumber(String subjectDN, String serialNumber) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"SubjectDN", (Object)subjectDN), Filters.eq((String)"SerialNumber", (Object)serialNumber), Filters.eq((String)"Status", (Object)CertificateStatus.VALID.name())});
    }

    public boolean contextIsUsed(String contextId) {
        return this.identityCollection.countDocuments(Filters.eq((String)"ContextId", (Object)contextId)) != 0L;
    }

    @Override
    public FindIterable<Document> findCertificate(String issuerDN, CertificateStatus certificateStatus) {
        return this.crlRepositoryHelper.findCertificate(issuerDN, certificateStatus);
    }

    @Override
    public void updateCertificateState(List<String> certificatesToUpdate, CertificateStatus certificateStatus) {
        this.crlRepositoryHelper.updateCertificateState(certificatesToUpdate, certificateStatus);
    }

    @Override
    public Class<IdentityModel> getEntityModelType() {
        return IdentityModel.class;
    }
}

