/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.repository;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.security.internal.common.model.CertificateStatus;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class CertificateCRLCheckRepositoryHelper {
    private final MongoCollection<Document> certificateCollection;

    public CertificateCRLCheckRepositoryHelper(MongoCollection<Document> certificateCollection) {
        this.certificateCollection = certificateCollection;
    }

    public FindIterable<Document> findCertificate(String issuerDN, CertificateStatus certificateStatus) {
        Bson crlCAFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"IssuerDN", (Object)issuerDN), Filters.eq((String)"Status", (Object)certificateStatus.name())});
        return this.certificateCollection.find(crlCAFilter);
    }

    public void updateCertificateState(List<String> certificatesToUpdate, CertificateStatus certificateStatus) {
        Bson fieldsToUpdateBson = Updates.set((String)"Status", (Object)certificateStatus.name());
        if (certificateStatus.equals((Object)CertificateStatus.REVOKED)) {
            fieldsToUpdateBson = Updates.combine((Bson[])new Bson[]{fieldsToUpdateBson, Updates.set((String)"RevocationDate", (Object)LocalDateUtil.nowFormatted())});
        }
        this.certificateCollection.updateMany(Filters.in((String)"_id", certificatesToUpdate), fieldsToUpdateBson);
    }
}

