/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.thread;

import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.configuration.CollectInternalConfiguration;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PurgeTransactionThread
implements Runnable {
    private static final String TRANSACTION_NOT_FOUND = "No transaction found";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeTransactionThread.class);
    private final TransactionService transactionService;
    private final Map<Integer, Integer> purgeTransactionDelayInMinutes;
    private final int threadPoolSize;

    public PurgeTransactionThread(CollectInternalConfiguration collectInternalConfiguration, TransactionService transactionService) {
        this.transactionService = transactionService;
        this.purgeTransactionDelayInMinutes = collectInternalConfiguration.getPurgeTransactionDelayInMinutes();
        Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()).scheduleAtFixedRate(this, collectInternalConfiguration.getPurgeTransactionThreadFrequency(), collectInternalConfiguration.getPurgeTransactionThreadFrequency(), TimeUnit.MINUTES);
        this.threadPoolSize = Math.min(collectInternalConfiguration.getPurgeTransactionThreadPoolSize(), VitamConfiguration.getTenants().size());
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when processing purge transaction: {}", (Throwable)e);
        }
    }

    public void deleteTransaction(Integer tenantId, Integer delay) throws CollectInternalException, ParseException {
        LOGGER.debug("start delete transaction content" + tenantId + " " + Thread.currentThread().getId());
        List transactionModelList = this.transactionService.getListTransactionToDeleteByTenant(tenantId);
        if (transactionModelList.isEmpty()) {
            LOGGER.debug(TRANSACTION_NOT_FOUND);
        }
        for (TransactionModel transactionModel : transactionModelList) {
            if (!this.isToDelete(transactionModel.getLastUpdate(), delay)) continue;
            this.transactionService.deleteTransactionContent(transactionModel.getId());
        }
    }

    private boolean isToDelete(String transactionDate, Integer delay) throws ParseException {
        Date dateLastUpdate = LocalDateUtil.getDate((String)transactionDate);
        Date dateNow = new Date(System.currentTimeMillis());
        long differenceInMinutes = (dateNow.getTime() - dateLastUpdate.getTime()) / 60000L;
        return differenceInMinutes >= (long)delay.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws CollectInternalException {
        Thread.currentThread().setName(PurgeTransactionThread.class.getName());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()));
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)this.threadPoolSize);
        ArrayList<CompletableFuture<Void>> completableFuturesList = new ArrayList<CompletableFuture<Void>>();
        try {
            for (Map.Entry<Integer, Integer> entry : this.purgeTransactionDelayInMinutes.entrySet()) {
                CompletableFuture<Void> traceabilityCompletableFuture = CompletableFuture.runAsync(() -> {
                    VitamThreadUtils.getVitamSession().setTenantId((Integer)entry.getKey());
                    try {
                        this.deleteTransaction((Integer)entry.getKey(), (Integer)entry.getValue());
                    }
                    catch (CollectInternalException | ParseException e) {
                        LOGGER.error("Error when deleting transaction: {}", e);
                    }
                }, executorService);
                completableFuturesList.add(traceabilityCompletableFuture);
            }
            CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(completableFuturesList.toArray(new CompletableFuture[0]));
            combinedFuture.join();
        }
        finally {
            executorService.shutdown();
        }
    }
}

