/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.retryable;

import fr.gouv.vitam.common.retryable.DelegateRetry;
import fr.gouv.vitam.common.retryable.DelegateRetryVoid;
import fr.gouv.vitam.common.retryable.Retryable;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class RetryableOnResult<T, E extends Exception>
implements Retryable<T, E> {
    private static final Consumer NOOP = r -> {};
    private final AtomicInteger counter = new AtomicInteger();
    private final SecureRandom randomSleep = new SecureRandom();
    private final Predicate<T> retryOn;
    private final Consumer<T> onResult;
    private RetryableParameters param;

    public RetryableOnResult(RetryableParameters param, Predicate<T> retryOn, Consumer<T> onResult) {
        this.param = Objects.requireNonNull(param);
        this.retryOn = Objects.requireNonNull(retryOn);
        this.onResult = Objects.requireNonNull(onResult);
    }

    public RetryableOnResult(RetryableParameters param, Predicate<T> retryOn) {
        this(param, retryOn, NOOP);
    }

    @Override
    public T exec(DelegateRetry<T, E> delegate) throws E {
        while (this.counter.getAndIncrement() < this.param.getNbRetry()) {
            T result = delegate.call();
            boolean attemptExceedNbRetry = this.counter.get() >= this.param.getNbRetry();
            boolean shouldStopRetry = this.retryOn.negate().test(result);
            if (attemptExceedNbRetry || shouldStopRetry) {
                return result;
            }
            this.sleep(this.counter.get(), delegate.toString(), this.param, this.randomSleep, this.onResult, result);
        }
        throw new IllegalStateException("Unreachable statement.");
    }

    @Override
    public void execute(DelegateRetryVoid<E> delegate) throws E {
        throw new IllegalStateException("Cannot use this function");
    }
}

